/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.XmlUpdateRequestHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHarness {
    protected CoreContainer container;
    private SolrCore core;
    private XPath xpath = XPathFactory.newInstance().newXPath();
    private DocumentBuilder builder;
    public XmlUpdateRequestHandler updater;

    public static SolrConfig createConfig(String confFile) {
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        try {
            return new SolrConfig(confFile);
        }
        catch (Exception xany) {
            throw new RuntimeException(xany);
        }
    }

    public TestHarness(String dataDirectory) {
        this(dataDirectory, "schema.xml");
    }

    public TestHarness(String dataDirectory, String schemaFile) {
        this(dataDirectory, "solrconfig.xml", schemaFile);
    }

    public TestHarness(String dataDirectory, String configFile, String schemaFile) {
        this(dataDirectory, TestHarness.createConfig(configFile), schemaFile);
    }

    public TestHarness(String dataDirectory, SolrConfig solrConfig, String schemaFile) {
        this(dataDirectory, solrConfig, new IndexSchema(solrConfig, schemaFile, null));
    }

    public TestHarness(String dataDirectory, SolrConfig solrConfig, IndexSchema indexSchema) {
        this("", new Initializer("", dataDirectory, solrConfig, indexSchema));
    }

    public TestHarness(String coreName, CoreContainer.Initializer init) {
        try {
            this.container = init.initialize();
            if (coreName == null) {
                coreName = "";
            }
            this.core = this.container.getCore(coreName);
            if (this.core != null) {
                this.core.close();
            }
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.updater = new XmlUpdateRequestHandler();
            this.updater.init(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CoreContainer getCoreContainer() {
        return this.container;
    }

    public SolrCore getCore() {
        return this.core;
    }

    @Deprecated
    public String update(String xml) {
        try {
            ByteArrayInputStream req = new ByteArrayInputStream(xml.getBytes("UTF-16BE"));
            StringWriter out = new StringWriter(32000);
            this.updater.doLegacyUpdate((InputStream)req, "application/xml; charset=UTF-16BE", (Writer)out);
            return out.toString();
        }
        catch (UnsupportedEncodingException uue) {
            throw new RuntimeException(uue);
        }
    }

    public String validateUpdate(String xml) throws SAXException {
        return this.checkUpdateStatus(xml, "0");
    }

    public String validateErrorUpdate(String xml) throws SAXException {
        return this.checkUpdateStatus(xml, "1");
    }

    public String checkUpdateStatus(String xml, String code) throws SAXException {
        try {
            String res = this.update(xml);
            String valid = this.validateXPath(res, "//result[@status=" + code + "]");
            return null == valid ? null : res;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("?!? static xpath has bug?", e);
        }
    }

    public String validateAddDoc(String ... fieldsAndValues) throws XPathExpressionException, SAXException, IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("<add>");
        this.appendSimpleDoc(buf, fieldsAndValues);
        buf.append("</add>");
        String res = this.update(buf.toString());
        String valid = this.validateXPath(res, "//result[@status=0]");
        return null == valid ? null : res;
    }

    public String validateQuery(SolrQueryRequest req, String ... tests) throws IOException, Exception {
        String res = this.query(req);
        return this.validateXPath(res, tests);
    }

    public String query(SolrQueryRequest req) throws IOException, Exception {
        return this.query(req.getParams().get("qt"), req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String query(String handler, SolrQueryRequest req) throws IOException, Exception {
        try {
            SolrQueryResponse rsp = new SolrQueryResponse();
            SolrRequestInfo.setRequestInfo((SolrRequestInfo)new SolrRequestInfo(req, rsp));
            this.core.execute(this.core.getRequestHandler(handler), req, rsp);
            if (rsp.getException() != null) {
                throw rsp.getException();
            }
            StringWriter sw = new StringWriter(32000);
            QueryResponseWriter responseWriter = this.core.getQueryResponseWriter(req);
            responseWriter.write((Writer)sw, req, rsp);
            req.close();
            String string = sw.toString();
            return string;
        }
        finally {
            req.close();
            SolrRequestInfo.clearRequestInfo();
        }
    }

    public SolrQueryResponse queryAndResponse(String handler, SolrQueryRequest req) throws Exception {
        SolrQueryResponse rsp = new SolrQueryResponse();
        this.core.execute(this.core.getRequestHandler(handler), req, rsp);
        if (rsp.getException() != null) {
            throw rsp.getException();
        }
        return rsp;
    }

    public String validateXPath(String xml, String ... tests) throws XPathExpressionException, SAXException {
        if (tests == null || tests.length == 0) {
            return null;
        }
        Document document = null;
        try {
            document = this.builder.parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException("Totally weird UTF-8 exception", e1);
        }
        catch (IOException e2) {
            throw new RuntimeException("Totally weird io exception", e2);
        }
        for (String xp : tests) {
            Boolean bool = (Boolean)this.xpath.evaluate(xp = xp.trim(), document, XPathConstants.BOOLEAN);
            if (bool.booleanValue()) continue;
            return xp;
        }
        return null;
    }

    public void close() {
        if (this.container != null) {
            for (SolrCore c : this.container.getCores()) {
                if (c.getOpenCount() <= 1) continue;
                throw new RuntimeException("SolrCore.getOpenCount()==" + this.core.getOpenCount());
            }
        }
        if (this.container != null) {
            this.container.shutdown();
            this.container = null;
        }
    }

    public void appendSimpleDoc(StringBuilder buf, String ... fieldsAndValues) throws IOException {
        buf.append(TestHarness.makeSimpleDoc(fieldsAndValues));
    }

    @Deprecated
    public void appendSimpleDoc(StringBuffer buf, String ... fieldsAndValues) throws IOException {
        buf.append(TestHarness.makeSimpleDoc(fieldsAndValues));
    }

    public static StringBuffer makeSimpleDoc(String ... fieldsAndValues) {
        try {
            StringWriter w = new StringWriter();
            w.append("<doc>");
            for (int i = 0; i < fieldsAndValues.length; i += 2) {
                XML.writeXML((Writer)w, (String)"field", (String)fieldsAndValues[i + 1], (Object[])new Object[]{"name", fieldsAndValues[i]});
            }
            w.append("</doc>");
            return w.getBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String deleteByQuery(String q, String ... args) {
        try {
            StringWriter r = new StringWriter();
            XML.writeXML((Writer)r, (String)"query", (String)q);
            return TestHarness.delete(r.getBuffer().toString(), args);
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String deleteById(String id, String ... args) {
        try {
            StringWriter r = new StringWriter();
            XML.writeXML((Writer)r, (String)"id", (String)id);
            return TestHarness.delete(r.getBuffer().toString(), args);
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    private static String delete(String val, String ... args) {
        try {
            StringWriter r = new StringWriter();
            XML.writeUnescapedXML((Writer)r, (String)"delete", (String)val, (Object[])args);
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String optimize(String ... args) {
        return TestHarness.simpleTag("optimize", args);
    }

    private static String simpleTag(String tag, String ... args) {
        try {
            StringWriter r = new StringWriter();
            if (null == args || 0 == args.length) {
                XML.writeXML((Writer)r, (String)tag, null);
            } else {
                XML.writeXML((Writer)r, (String)tag, null, (Object[])args);
            }
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String commit(String ... args) {
        return TestHarness.simpleTag("commit", args);
    }

    public LocalRequestFactory getRequestFactory(String qtype, int start, int limit) {
        LocalRequestFactory f = new LocalRequestFactory();
        f.qtype = qtype;
        f.start = start;
        f.limit = limit;
        return f;
    }

    public LocalRequestFactory getRequestFactory(String qtype, int start, int limit, String ... args) {
        LocalRequestFactory f = this.getRequestFactory(qtype, start, limit);
        for (int i = 0; i < args.length; i += 2) {
            f.args.put(args[i], args[i + 1]);
        }
        return f;
    }

    public LocalRequestFactory getRequestFactory(String qtype, int start, int limit, Map<String, String> args) {
        LocalRequestFactory f = this.getRequestFactory(qtype, start, limit);
        f.args.putAll(args);
        return f;
    }

    public class LocalRequestFactory {
        public String qtype = "standard";
        public int start = 0;
        public int limit = 1000;
        public Map<String, String> args = new HashMap<String, String>();

        public LocalSolrQueryRequest makeRequest(String ... q) {
            if (q.length == 1) {
                return new LocalSolrQueryRequest(TestHarness.this.getCore(), q[0], this.qtype, this.start, this.limit, this.args);
            }
            if (q.length % 2 != 0) {
                throw new RuntimeException("The length of the string array (query arguments) needs to be even");
            }
            NamedList.NamedListEntry[] entries = new NamedList.NamedListEntry[q.length / 2];
            for (int i = 0; i < q.length; i += 2) {
                entries[i / 2] = new NamedList.NamedListEntry(q[i], (Object)q[i + 1]);
            }
            return new LocalSolrQueryRequest(TestHarness.this.getCore(), new NamedList((Map.Entry[])entries));
        }
    }

    static class Initializer
    extends CoreContainer.Initializer {
        String coreName;
        String dataDirectory;
        SolrConfig solrConfig;
        IndexSchema indexSchema;

        public Initializer(String coreName, String dataDirectory, SolrConfig solrConfig, IndexSchema indexSchema) {
            if (coreName == null) {
                coreName = "";
            }
            this.coreName = coreName;
            this.dataDirectory = dataDirectory;
            this.solrConfig = solrConfig;
            this.indexSchema = indexSchema;
        }

        public String getCoreName() {
            return this.coreName;
        }

        public CoreContainer initialize() {
            CoreContainer container = new CoreContainer(new SolrResourceLoader(SolrResourceLoader.locateSolrHome()));
            CoreDescriptor dcore = new CoreDescriptor(container, this.coreName, this.solrConfig.getResourceLoader().getInstanceDir());
            dcore.setConfigName(this.solrConfig.getResourceName());
            dcore.setSchemaName(this.indexSchema.getResourceName());
            SolrCore core = new SolrCore(null, this.dataDirectory, this.solrConfig, this.indexSchema, dcore);
            container.register(this.coreName, core, false);
            return container;
        }
    }
}

