/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Map;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataConfig;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.VariableResolverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedEntityProcessorWrapper
extends EntityProcessorWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadedEntityProcessorWrapper.class);
    final DocBuilder.EntityRunner entityRunner;
    final Map<DataConfig.Entity, DocBuilder.EntityRunner> children;
    private final int number;

    public ThreadedEntityProcessorWrapper(EntityProcessor delegate, DocBuilder docBuilder, DocBuilder.EntityRunner entityRunner, VariableResolverImpl resolver, Map<DataConfig.Entity, DocBuilder.EntityRunner> childrenRunners, int num) {
        super(delegate, docBuilder);
        this.entityRunner = entityRunner;
        this.resolver = resolver;
        this.children = childrenRunners;
        this.number = num;
    }

    void threadedInit(Context context) {
        this.rowcache = null;
        this.context = context;
        this.resolver = (VariableResolverImpl)context.getVariableResolver();
        if (this.entityName == null) {
            this.onError = this.resolver.replaceTokens(context.getEntityAttribute("onError"));
            if (this.onError == null) {
                this.onError = "abort";
            }
            this.entityName = context.getEntityAttribute("name");
        }
    }

    public void init(DocBuilder.EntityRow rows) {
        DocBuilder.EntityRow row = rows;
        while (row != null) {
            this.resolver.addNamespace(row.name, row.row);
            row = row.tail;
        }
    }

    public int getNumber() {
        return this.number;
    }
}

