/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.util.Base64Utils;
import org.mobylet.core.util.StringUtils;

public class SerializeUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize2Bytes(Object obj) {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            Object object = obj;
            synchronized (object) {
                oos.writeObject(obj);
            }
            object = baos.toByteArray();
            return object;
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u30b7\u30ea\u30a2\u30e9\u30a4\u30ba\u306b\u5931\u6557", e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String serialize2Base64String(Object obj) {
        return Base64Utils.encode(SerializeUtils.serialize2Bytes(obj));
    }

    public static Object deserialize(String objString) {
        if (StringUtils.isEmpty(objString)) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64Utils.decode(objString));
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u30c7\u30b7\u30ea\u30a2\u30e9\u30a4\u30ba\u306b\u5931\u6557", e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

