/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.emoji.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mobylet.core.Carrier;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.emoji.Emoji;
import org.mobylet.core.emoji.EmojiPool;
import org.mobylet.core.emoji.EmojiPoolFamily;
import org.mobylet.core.emoji.EmojiPoolReader;
import org.mobylet.core.util.SingletonUtils;

public class MobyletEmojiPoolFamily
implements EmojiPoolFamily {
    public String pathEmojiDocomo = "mobylet.emojistocker.docomo.xml";
    public String pathEmojiAu = "mobylet.emojistocker.au.xml";
    public String pathEmojiSoftbank = "mobylet.emojistocker.softbank.xml";
    protected Map<Carrier, EmojiPool> family;
    protected EmojiPool[] poolArray;
    protected int minEmoji = 65535;
    protected int maxEmoji = 0;

    @Override
    public EmojiPool getEmojiPool(Carrier carrier) {
        EmojiPool pool = this.family.get((Object)carrier);
        if (pool == null) {
            pool = new EmojiPool(carrier);
            this.family.put(carrier, pool);
        }
        return pool;
    }

    @Override
    public Emoji getEmoji(char c) {
        if (this.poolArray == null) {
            return null;
        }
        if (c < this.minEmoji || c > this.maxEmoji) {
            return null;
        }
        for (EmojiPool stocker : this.poolArray) {
            if (!stocker.isEmoji(c)) continue;
            return stocker.get(c);
        }
        return null;
    }

    @Override
    public boolean isEmoji(char c) {
        if (this.poolArray != null && this.minEmoji <= c && c <= this.maxEmoji) {
            for (EmojiPool pool : this.poolArray) {
                if (!pool.isEmoji(c)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void initialize() {
        this.family = new LinkedHashMap<Carrier, EmojiPool>();
        EmojiPoolReader reader = SingletonUtils.get(EmojiPoolReader.class);
        MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
        this.stock(reader, config.getEmojiDir() + this.pathEmojiDocomo);
        this.stock(reader, config.getEmojiDir() + this.pathEmojiAu);
        this.stock(reader, config.getEmojiDir() + this.pathEmojiSoftbank);
        this.family.remove((Object)Carrier.OTHER);
        this.poolArray = new EmojiPool[this.family.size()];
        int index = 0;
        for (EmojiPool pool : this.family.values()) {
            pool.construct();
            this.poolArray[index++] = pool;
            if (pool.getMinEmoji() < this.minEmoji) {
                this.minEmoji = pool.getMinEmoji();
            }
            if (pool.getMaxEmoji() <= this.maxEmoji) continue;
            this.maxEmoji = pool.getMaxEmoji();
        }
    }

    protected void stock(EmojiPoolReader reader, String path) {
        EmojiPool pool = null;
        if (reader != null && (pool = reader.read(path).get()) != null) {
            this.family.put(pool.getCarrier(), pool);
        }
    }
}

