/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.util.BCDUtils;

public class BCDIntField
extends PrimitiveFieldType {
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    public ValueSource getValueSource(SchemaField field) {
        throw new UnsupportedOperationException("ValueSource not implemented");
    }

    public String toInternal(String val) {
        return BCDUtils.base10toBase10kSortableInt(val);
    }

    public String toExternal(Fieldable f) {
        return this.indexedToReadable(f.stringValue());
    }

    public Object toObject(Fieldable f) {
        return Integer.valueOf(this.toExternal(f));
    }

    public String indexedToReadable(String indexedForm) {
        return BCDUtils.base10kSortableIntToBase10(indexedForm);
    }

    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeInt(name, this.toExternal(f));
    }

    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        writer.writeInt(name, this.toExternal(f));
    }
}

