/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.manager;

import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.seasar.extension.datasource.DataSourceFactory;
import org.seasar.extension.datasource.impl.SelectableDataSourceProxy;
import org.seasar.extension.jdbc.AutoBatchDelete;
import org.seasar.extension.jdbc.AutoBatchInsert;
import org.seasar.extension.jdbc.AutoBatchUpdate;
import org.seasar.extension.jdbc.AutoDelete;
import org.seasar.extension.jdbc.AutoFunctionCall;
import org.seasar.extension.jdbc.AutoInsert;
import org.seasar.extension.jdbc.AutoProcedureCall;
import org.seasar.extension.jdbc.AutoSelect;
import org.seasar.extension.jdbc.AutoUpdate;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.EntityMetaFactory;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.extension.jdbc.SqlBatchUpdate;
import org.seasar.extension.jdbc.SqlFileBatchUpdate;
import org.seasar.extension.jdbc.SqlFileFunctionCall;
import org.seasar.extension.jdbc.SqlFileProcedureCall;
import org.seasar.extension.jdbc.SqlFileSelect;
import org.seasar.extension.jdbc.SqlFileUpdate;
import org.seasar.extension.jdbc.SqlFunctionCall;
import org.seasar.extension.jdbc.SqlProcedureCall;
import org.seasar.extension.jdbc.SqlSelect;
import org.seasar.extension.jdbc.SqlUpdate;
import org.seasar.extension.jdbc.exception.NoIdPropertyRuntimeException;
import org.seasar.extension.jdbc.manager.JdbcContextImpl;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AutoBatchDeleteImpl;
import org.seasar.extension.jdbc.query.AutoBatchInsertImpl;
import org.seasar.extension.jdbc.query.AutoBatchUpdateImpl;
import org.seasar.extension.jdbc.query.AutoDeleteImpl;
import org.seasar.extension.jdbc.query.AutoFunctionCallImpl;
import org.seasar.extension.jdbc.query.AutoInsertImpl;
import org.seasar.extension.jdbc.query.AutoProcedureCallImpl;
import org.seasar.extension.jdbc.query.AutoSelectImpl;
import org.seasar.extension.jdbc.query.AutoUpdateImpl;
import org.seasar.extension.jdbc.query.SqlBatchUpdateImpl;
import org.seasar.extension.jdbc.query.SqlFileBatchUpdateImpl;
import org.seasar.extension.jdbc.query.SqlFileFunctionCallImpl;
import org.seasar.extension.jdbc.query.SqlFileProcedureCallImpl;
import org.seasar.extension.jdbc.query.SqlFileSelectImpl;
import org.seasar.extension.jdbc.query.SqlFileUpdateImpl;
import org.seasar.extension.jdbc.query.SqlFunctionCallImpl;
import org.seasar.extension.jdbc.query.SqlProcedureCallImpl;
import org.seasar.extension.jdbc.query.SqlSelectImpl;
import org.seasar.extension.jdbc.query.SqlUpdateImpl;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.convention.PersistenceConvention;
import org.seasar.framework.exception.EmptyRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcManagerImpl
implements JdbcManager,
JdbcManagerImplementor {
    protected TransactionSynchronizationRegistry syncRegistry;
    protected DataSourceFactory dataSourceFactory;
    protected DataSource dataSource;
    protected DbmsDialect dialect;
    protected EntityMetaFactory entityMetaFactory;
    protected PersistenceConvention persistenceConvention;
    protected int maxRows = 0;
    protected int fetchSize = 0;
    protected int queryTimeout = 0;
    protected boolean allowVariableSqlForBatchUpdate = true;

    @Override
    public <T> AutoSelect<T> from(Class<T> baseClass) {
        return (AutoSelect)((AutoSelect)((AutoSelect)new AutoSelectImpl<T>(this, baseClass).maxRows(this.maxRows)).fetchSize(this.fetchSize)).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> SqlSelect<T> selectBySql(Class<T> baseClass, String sql, Object ... params) {
        return (SqlSelect)((SqlSelect)((SqlSelect)new SqlSelectImpl<T>(this, baseClass, sql, params).maxRows(this.maxRows)).fetchSize(this.fetchSize)).queryTimeout(this.queryTimeout);
    }

    @Override
    public long getCountBySql(String sql, Object ... params) {
        return new SqlSelectImpl<Long>(this, Long.class, sql, params).getCount();
    }

    @Override
    public <T> SqlFileSelect<T> selectBySqlFile(Class<T> baseClass, String path) {
        return this.selectBySqlFile(baseClass, path, null);
    }

    @Override
    public <T> SqlFileSelect<T> selectBySqlFile(Class<T> baseClass, String path, Object parameter) {
        return (SqlFileSelect)((SqlFileSelect)((SqlFileSelect)new SqlFileSelectImpl<T>(this, baseClass, path, parameter).maxRows(this.maxRows)).fetchSize(this.fetchSize)).queryTimeout(this.queryTimeout);
    }

    @Override
    public long getCountBySqlFile(String path) {
        return new SqlFileSelectImpl<Long>(this, Long.class, path, null).getCount();
    }

    @Override
    public long getCountBySqlFile(String path, Object parameter) {
        return new SqlFileSelectImpl<Long>(this, Long.class, path, parameter).getCount();
    }

    @Override
    public <T> AutoInsert<T> insert(T entity) {
        return (AutoInsert)new AutoInsertImpl<T>(this, entity).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> AutoBatchInsert<T> insertBatch(T ... entities) {
        return (AutoBatchInsert)new AutoBatchInsertImpl<T>(this, Arrays.asList(entities)).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> AutoBatchInsert<T> insertBatch(List<T> entities) {
        return (AutoBatchInsert)new AutoBatchInsertImpl<T>(this, entities).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> AutoUpdate<T> update(T entity) {
        EntityMeta entityMeta = this.entityMetaFactory.getEntityMeta(entity.getClass());
        if (entityMeta.getIdPropertyMetaList().isEmpty()) {
            throw new NoIdPropertyRuntimeException("ESSR0761", entityMeta.getName());
        }
        return (AutoUpdate)new AutoUpdateImpl<T>(this, entity).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> AutoBatchUpdate<T> updateBatch(T ... entities) {
        if (entities == null) {
            throw new NullPointerException("entities");
        }
        if (entities.length == 0) {
            throw new EmptyRuntimeException("entities");
        }
        EntityMeta entityMeta = this.entityMetaFactory.getEntityMeta(entities[0].getClass());
        if (entityMeta.getIdPropertyMetaList().isEmpty()) {
            throw new NoIdPropertyRuntimeException("ESSR0761", entityMeta.getName());
        }
        return (AutoBatchUpdate)new AutoBatchUpdateImpl<T>(this, Arrays.asList(entities)).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> AutoBatchUpdate<T> updateBatch(List<T> entities) {
        if (entities == null) {
            throw new NullPointerException("entities");
        }
        if (entities.isEmpty()) {
            throw new EmptyRuntimeException("entities");
        }
        EntityMeta entityMeta = this.entityMetaFactory.getEntityMeta(entities.get(0).getClass());
        if (entityMeta.getIdPropertyMetaList().isEmpty()) {
            throw new NoIdPropertyRuntimeException("ESSR0761", entityMeta.getName());
        }
        return (AutoBatchUpdate)new AutoBatchUpdateImpl<T>(this, entities).queryTimeout(this.queryTimeout);
    }

    @Override
    public SqlUpdate updateBySql(String sql, Class<?> ... paramClasses) {
        return (SqlUpdate)new SqlUpdateImpl(this, sql, paramClasses).queryTimeout(this.queryTimeout);
    }

    @Override
    public SqlBatchUpdate updateBatchBySql(String sql, Class<?> ... paramClasses) {
        return (SqlBatchUpdate)new SqlBatchUpdateImpl(this, sql, paramClasses).queryTimeout(this.queryTimeout);
    }

    @Override
    public SqlFileUpdate updateBySqlFile(String path) {
        return (SqlFileUpdate)new SqlFileUpdateImpl(this, path).queryTimeout(this.queryTimeout);
    }

    @Override
    public SqlFileUpdate updateBySqlFile(String path, Object parameter) {
        return (SqlFileUpdate)new SqlFileUpdateImpl(this, path, parameter).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> SqlFileBatchUpdate<T> updateBatchBySqlFile(String path, List<T> params) {
        return (SqlFileBatchUpdate)new SqlFileBatchUpdateImpl<T>(this, path, params).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> SqlFileBatchUpdate<T> updateBatchBySqlFile(String path, T ... params) {
        return (SqlFileBatchUpdate)new SqlFileBatchUpdateImpl<T>(this, path, Arrays.asList(params)).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> AutoDelete<T> delete(T entity) {
        EntityMeta entityMeta = this.entityMetaFactory.getEntityMeta(entity.getClass());
        if (entityMeta.getIdPropertyMetaList().isEmpty()) {
            throw new NoIdPropertyRuntimeException("ESSR0762", entityMeta.getName());
        }
        return (AutoDelete)new AutoDeleteImpl<T>(this, entity).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> AutoBatchDelete<T> deleteBatch(T ... entities) {
        if (entities == null) {
            throw new NullPointerException("entities");
        }
        if (entities.length == 0) {
            throw new EmptyRuntimeException("entities");
        }
        EntityMeta entityMeta = this.entityMetaFactory.getEntityMeta(entities[0].getClass());
        if (entityMeta.getIdPropertyMetaList().isEmpty()) {
            throw new NoIdPropertyRuntimeException("ESSR0762", entityMeta.getName());
        }
        return (AutoBatchDelete)new AutoBatchDeleteImpl<T>(this, Arrays.asList(entities)).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> AutoBatchDelete<T> deleteBatch(List<T> entities) {
        if (entities == null) {
            throw new NullPointerException("entities");
        }
        if (entities.isEmpty()) {
            throw new EmptyRuntimeException("entities");
        }
        EntityMeta entityMeta = this.entityMetaFactory.getEntityMeta(entities.get(0).getClass());
        if (entityMeta.getIdPropertyMetaList().isEmpty()) {
            throw new NoIdPropertyRuntimeException("ESSR0762", entityMeta.getName());
        }
        return (AutoBatchDelete)new AutoBatchDeleteImpl<T>(this, entities).queryTimeout(this.queryTimeout);
    }

    @Override
    public AutoProcedureCall call(String procedureName) {
        return this.call(procedureName, null);
    }

    @Override
    public AutoProcedureCall call(String procedureName, Object parameter) {
        return (AutoProcedureCall)((AutoProcedureCall)((AutoProcedureCall)new AutoProcedureCallImpl(this, procedureName, parameter).maxRows(this.maxRows)).fetchSize(this.fetchSize)).queryTimeout(this.queryTimeout);
    }

    @Override
    public SqlProcedureCall callBySql(String sql) {
        return this.callBySql(sql, null);
    }

    @Override
    public SqlProcedureCall callBySql(String sql, Object parameter) {
        return (SqlProcedureCall)((SqlProcedureCall)((SqlProcedureCall)new SqlProcedureCallImpl(this, sql, parameter).maxRows(this.maxRows)).fetchSize(this.fetchSize)).queryTimeout(this.queryTimeout);
    }

    @Override
    public SqlFileProcedureCall callBySqlFile(String path) {
        return this.callBySqlFile(path, null);
    }

    @Override
    public SqlFileProcedureCall callBySqlFile(String path, Object parameter) {
        return (SqlFileProcedureCall)((SqlFileProcedureCall)((SqlFileProcedureCall)new SqlFileProcedureCallImpl(this, path, parameter).maxRows(this.maxRows)).fetchSize(this.fetchSize)).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> AutoFunctionCall<T> call(Class<T> resultClass, String functionName) {
        return this.call(resultClass, functionName, null);
    }

    @Override
    public <T> AutoFunctionCall<T> call(Class<T> resultClass, String functionName, Object parameter) {
        return (AutoFunctionCall)((AutoFunctionCall)((AutoFunctionCall)new AutoFunctionCallImpl<T>(this, resultClass, functionName, parameter).maxRows(this.maxRows)).fetchSize(this.fetchSize)).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> SqlFunctionCall<T> callBySql(Class<T> resultClass, String sql) {
        return this.callBySql(resultClass, sql, null);
    }

    @Override
    public <T> SqlFunctionCall<T> callBySql(Class<T> resultClass, String sql, Object parameter) {
        return (SqlFunctionCall)((SqlFunctionCall)((SqlFunctionCall)new SqlFunctionCallImpl<T>(this, resultClass, sql, parameter).maxRows(this.maxRows)).fetchSize(this.fetchSize)).queryTimeout(this.queryTimeout);
    }

    @Override
    public <T> SqlFileFunctionCall<T> callBySqlFile(Class<T> resultClass, String path) {
        return this.callBySqlFile(resultClass, path, null);
    }

    @Override
    public <T> SqlFileFunctionCall<T> callBySqlFile(Class<T> resultClass, String path, Object parameter) {
        return (SqlFileFunctionCall)((SqlFileFunctionCall)((SqlFileFunctionCall)new SqlFileFunctionCallImpl<T>(this, resultClass, path, parameter).maxRows(this.maxRows)).fetchSize(this.fetchSize)).queryTimeout(this.queryTimeout);
    }

    @Override
    public JdbcContext getJdbcContext() {
        JdbcContext ctx = this.getTxBoundJdbcContext();
        if (ctx != null) {
            return ctx;
        }
        Connection con = DataSourceUtil.getConnection((DataSource)this.dataSource);
        if (this.hasTransaction()) {
            ctx = this.createJdbcContext(con, true);
            this.setTxBoundJdbcContext(ctx);
        } else {
            ctx = this.createJdbcContext(con, false);
        }
        return ctx;
    }

    @Override
    public String getSelectableDataSourceName() {
        return this.getSelectableDataSourceNameInternal();
    }

    protected String getSelectableDataSourceNameInternal() {
        if (this.dataSource instanceof SelectableDataSourceProxy && this.dataSourceFactory != null) {
            return this.dataSourceFactory.getSelectableDataSourceName();
        }
        return null;
    }

    protected JdbcContext getTxBoundJdbcContext() {
        JdbcContextRegistryKey key;
        JdbcContext ctx;
        if (this.hasTransaction() && (ctx = (JdbcContext)JdbcContext.class.cast(this.syncRegistry.getResource((Object)(key = this.createJdbcContextRegistryKey())))) != null) {
            return ctx;
        }
        return null;
    }

    protected void setTxBoundJdbcContext(JdbcContext ctx) {
        JdbcContextRegistryKey key = this.createJdbcContextRegistryKey();
        this.syncRegistry.putResource((Object)key, (Object)ctx);
        this.syncRegistry.registerInterposedSynchronization((Synchronization)new SynchronizationImpl(ctx));
    }

    protected JdbcContextRegistryKey createJdbcContextRegistryKey() {
        return new JdbcContextRegistryKey(this.getSelectableDataSourceNameInternal());
    }

    protected boolean hasTransaction() {
        int status = this.syncRegistry.getTransactionStatus();
        return status != 6 && status != 5;
    }

    protected boolean isJdbcContextNull() {
        return this.getTxBoundJdbcContext() == null;
    }

    protected JdbcContext createJdbcContext(Connection connection, boolean transactional) {
        return new JdbcContextImpl(connection, transactional);
    }

    public TransactionSynchronizationRegistry getSyncRegistry() {
        return this.syncRegistry;
    }

    public void setSyncRegistry(TransactionSynchronizationRegistry syncRegistry) {
        this.syncRegistry = syncRegistry;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public boolean isAllowVariableSqlForBatchUpdate() {
        return this.allowVariableSqlForBatchUpdate;
    }

    public void setAllowVariableSqlForBatchUpdate(boolean allowVariableSqlForBatchUpdate) {
        this.allowVariableSqlForBatchUpdate = allowVariableSqlForBatchUpdate;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    @Override
    public DbmsDialect getDialect() {
        return this.dialect;
    }

    public void setDialect(DbmsDialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public EntityMetaFactory getEntityMetaFactory() {
        return this.entityMetaFactory;
    }

    public void setEntityMetaFactory(EntityMetaFactory entityMetaFactory) {
        this.entityMetaFactory = entityMetaFactory;
    }

    @Override
    public PersistenceConvention getPersistenceConvention() {
        return this.persistenceConvention;
    }

    public void setPersistenceConvention(PersistenceConvention persistenceConvention) {
        this.persistenceConvention = persistenceConvention;
    }

    public class JdbcContextRegistryKey {
        protected String dataSourceName;

        public JdbcContextRegistryKey(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.dataSourceName == null ? 0 : this.dataSourceName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JdbcContextRegistryKey other = (JdbcContextRegistryKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.dataSourceName == null ? other.dataSourceName != null : !this.dataSourceName.equals(other.dataSourceName));
        }

        private JdbcManagerImpl getOuterType() {
            return JdbcManagerImpl.this;
        }
    }

    public class SynchronizationImpl
    implements Synchronization {
        protected final JdbcContext context;

        public SynchronizationImpl(JdbcContext context) {
            this.context = context;
        }

        public final void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.context.destroy();
        }
    }
}

