/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.dialect;

import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.dialect.StandardDialect;

public class FirebirdDialect
extends StandardDialect {
    public String getName() {
        return "firebird";
    }

    public boolean supportsLimit() {
        return true;
    }

    public String convertLimitSql(String sql, int offset, int limit) {
        StringBuilder buf = new StringBuilder(sql.length() + 20);
        String lowerSql = sql.toLowerCase();
        int startOfSelect = lowerSql.indexOf("select");
        buf.append(sql.substring(0, startOfSelect + 6));
        if (offset > 0) {
            buf.append(" first ");
            buf.append(offset + limit);
            buf.append(" skip ");
            buf.append(offset);
        } else {
            buf.append(" first ");
            buf.append(limit);
        }
        buf.append(sql.substring(startOfSelect + 6));
        return buf.toString();
    }

    public GenerationType getDefaultGenerationType() {
        return GenerationType.SEQUENCE;
    }

    public boolean supportsSequence() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName, int allocationSize) {
        return "select gen_id( " + sequenceName + ", " + allocationSize + " ) from RDB$DATABASE";
    }
}

