/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.pkg.ZipContainerDetector;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

abstract class AbstractPOIFSExtractor {
    private final EmbeddedDocumentExtractor extractor;

    protected AbstractPOIFSExtractor(ParseContext context) {
        EmbeddedDocumentExtractor ex = (EmbeddedDocumentExtractor)context.get(EmbeddedDocumentExtractor.class);
        this.extractor = ex == null ? new ParsingEmbeddedDocumentExtractor(context) : ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEmbeddedResource(TikaInputStream resource, String filename, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        try {
            Metadata metadata = new Metadata();
            if (filename != null) {
                metadata.set("tika.mime.file", filename);
                metadata.set("resourceName", filename);
            }
            if (mediaType != null) {
                metadata.set("Content-Type", mediaType);
            }
            if (this.extractor.shouldParseEmbedded(metadata)) {
                this.extractor.parseEmbedded((InputStream)resource, (ContentHandler)xhtml, metadata, outputHtml);
            }
        }
        finally {
            resource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEmbeddedOfficeDoc(DirectoryEntry dir, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        if (dir.hasEntry("Package")) {
            Entry ooxml = dir.getEntry("Package");
            TikaInputStream stream = TikaInputStream.get((InputStream)new DocumentInputStream((DocumentEntry)ooxml));
            try {
                ZipContainerDetector detector = new ZipContainerDetector();
                MediaType type = detector.detect((InputStream)stream, new Metadata());
                this.handleEmbeddedResource(stream, null, type.toString(), xhtml, true);
                return;
            }
            finally {
                stream.close();
            }
        }
        Metadata metadata = new Metadata();
        OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(dir);
        TikaInputStream embedded = null;
        try {
            if (type == OfficeParser.POIFSDocumentType.OLE10_NATIVE) {
                try {
                    Ole10Native ole = Ole10Native.createFromEmbeddedOleObject((DirectoryNode)((DirectoryNode)dir));
                    metadata.set("resourceName", dir.getName() + '/' + ole.getLabel());
                    byte[] data = ole.getDataBuffer();
                    embedded = TikaInputStream.get((byte[])data);
                }
                catch (Ole10NativeException ex) {}
            } else {
                metadata.set("Content-Type", type.getType().toString());
                metadata.set("resourceName", dir.getName() + '.' + type.getExtension());
            }
            if (this.extractor.shouldParseEmbedded(metadata)) {
                if (embedded == null) {
                    embedded = TikaInputStream.get((byte[])new byte[0]);
                    embedded.setOpenContainer((Object)dir);
                }
                this.extractor.parseEmbedded((InputStream)embedded, (ContentHandler)xhtml, metadata, true);
            }
        }
        finally {
            if (embedded != null) {
                embedded.close();
            }
        }
    }
}

