/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.twowaysql.node;

import org.seasar.robot.dbflute.twowaysql.context.CommandContext;
import org.seasar.robot.dbflute.twowaysql.node.ElseNode;
import org.seasar.robot.dbflute.twowaysql.node.IfCommentEvaluator;
import org.seasar.robot.dbflute.twowaysql.node.LoopAcceptable;
import org.seasar.robot.dbflute.twowaysql.node.LoopInfo;
import org.seasar.robot.dbflute.twowaysql.node.ParameterFinder;
import org.seasar.robot.dbflute.twowaysql.node.ScopeNode;
import org.seasar.robot.dbflute.twowaysql.node.SqlConnectorAdjustable;
import org.seasar.robot.dbflute.util.DfTypeUtil;
import org.seasar.robot.dbflute.util.Srl;

public class IfNode
extends ScopeNode
implements LoopAcceptable,
SqlConnectorAdjustable {
    public static final String PREFIX = "IF ";
    protected final String _expression;
    protected final String _specifiedSql;
    protected ElseNode _elseNode;

    public IfNode(String expression, String specifiedSql) {
        this._expression = expression;
        this._specifiedSql = specifiedSql;
    }

    public void accept(CommandContext ctx) {
        this.doAcceptByEvaluator(ctx, null);
    }

    public void accept(CommandContext ctx, LoopInfo loopInfo) {
        this.doAcceptByEvaluator(ctx, loopInfo);
    }

    protected void doAcceptByEvaluator(CommandContext ctx, LoopInfo loopInfo) {
        IfCommentEvaluator evaluator = this.createIfCommentEvaluator(ctx, loopInfo);
        boolean result = evaluator.evaluate();
        if (result) {
            this.processAcceptingChildren(ctx, loopInfo);
            ctx.setEnabled(true);
        } else if (this._elseNode != null) {
            if (loopInfo != null) {
                this._elseNode.accept(ctx, loopInfo);
            } else {
                this._elseNode.accept(ctx);
            }
        }
    }

    protected IfCommentEvaluator createIfCommentEvaluator(final CommandContext ctx, LoopInfo loopInfo) {
        return new IfCommentEvaluator(new ParameterFinder(){

            public Object find(String name) {
                return ctx.getArg(name);
            }
        }, this._expression, this._specifiedSql, loopInfo);
    }

    protected String replace(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    public String toString() {
        return DfTypeUtil.toClassTitle(this) + ":{" + this._expression + ", " + this._elseNode + "}";
    }

    public String getExpression() {
        return this._expression;
    }

    public ElseNode getElseNode() {
        return this._elseNode;
    }

    public void setElseNode(ElseNode elseNode) {
        this._elseNode = elseNode;
    }
}

