/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean;

import java.util.ArrayList;
import java.util.List;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.cbean.ListResultBean;
import org.seasar.robot.dbflute.cbean.PagingBean;
import org.seasar.robot.dbflute.cbean.PagingResultBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultBeanBuilder<ENTITY> {
    protected String _tableDbName;

    public ResultBeanBuilder(String tableDbName) {
        this._tableDbName = tableDbName;
    }

    public ListResultBean<ENTITY> buildListResultBean(List<ENTITY> selectedList) {
        ListResultBean<ENTITY> rb = new ListResultBean<ENTITY>();
        rb.setTableDbName(this._tableDbName);
        rb.setAllRecordCount(selectedList.size());
        rb.setSelectedList(selectedList);
        return rb;
    }

    public ListResultBean<ENTITY> buildListResultBean(ConditionBean cb, List<ENTITY> selectedList) {
        ListResultBean<ENTITY> rb = new ListResultBean<ENTITY>();
        rb.setTableDbName(this._tableDbName);
        rb.setAllRecordCount(selectedList.size());
        rb.setSelectedList(selectedList);
        rb.setOrderByClause(cb.getOrderByComponent());
        return rb;
    }

    public ListResultBean<ENTITY> buildEmptyListResultBean(PagingBean pb) {
        ListResultBean<ENTITY> rb = new ListResultBean<ENTITY>();
        rb.setTableDbName(this._tableDbName);
        rb.setAllRecordCount(0);
        rb.setSelectedList(this.newEmptyList());
        rb.setOrderByClause(pb.getOrderByComponent());
        return rb;
    }

    protected List<ENTITY> newEmptyList() {
        return new ArrayList();
    }

    public PagingResultBean<ENTITY> buildPagingResultBean(PagingBean pb, int allRecordCount, List<ENTITY> selectedList) {
        PagingResultBean<ENTITY> rb = new PagingResultBean<ENTITY>();
        rb.setTableDbName(this._tableDbName);
        rb.setAllRecordCount(allRecordCount);
        rb.setSelectedList(selectedList);
        rb.setOrderByClause(pb.getOrderByComponent());
        rb.setPageSize(pb.getFetchSize());
        rb.setCurrentPageNumber(pb.getFetchPageNumber());
        return rb;
    }
}

