/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.carrot2.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private static final Pattern CAMEL_CASE_SEGMENT_PATTERN = Pattern.compile("([A-Z]*)([A-Z0-9][a-z0-9]*)");
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("<.+?>", 2);

    private StringUtils() {
    }

    public static <T> String toString(Iterable<T> iterable, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            T object = iterator.next();
            stringBuilder.append(object);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(separator);
        }
        return stringBuilder.toString();
    }

    public static String splitCamelCase(String camelCaseString) {
        Matcher matcher = CAMEL_CASE_SEGMENT_PATTERN.matcher(camelCaseString);
        ArrayList<String> parts = new ArrayList<String>();
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String group = matcher.group(i);
                if (group.length() == 0) continue;
                parts.add(group);
            }
        }
        return org.apache.commons.lang.StringUtils.join(parts, (char)' ');
    }

    public static String urlEncodeWrapException(String string, String encoding) {
        try {
            return URLEncoder.encode(string, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.wrapAsRuntimeException(e);
        }
    }

    public static String removeHtmlTags(String string) {
        return HTML_TAG_PATTERN.matcher(string).replaceAll("");
    }

    public static String identifierToHumanReadable(String string) {
        return WordUtils.capitalizeFully((String)string.replace('_', ' '));
    }

    public static String join(String delim, Object ... objects) {
        StringBuilder b = new StringBuilder();
        for (Object s : objects) {
            if (s == null) continue;
            if (b.length() > 0) {
                b.append(delim);
            }
            b.append(s.toString());
        }
        return b.toString();
    }
}

