/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorServiceUtils {
    public static ExecutorService createExecutorService(int maxConcurrentThreads, Class<?> clazz) {
        ExecutorService service = Executors.newFixedThreadPool(maxConcurrentThreads, ExecutorServiceUtils.contextClassLoaderThreadFactory(clazz.getClassLoader()));
        return service;
    }

    private static ThreadFactory contextClassLoaderThreadFactory(final ClassLoader clazzLoader) {
        ThreadFactory tf = new ThreadFactory(){
            private final ThreadFactory delegate = Executors.defaultThreadFactory();

            public Thread newThread(Runnable r) {
                Thread t = this.delegate.newThread(r);
                t.setDaemon(true);
                t.setContextClassLoader(clazzLoader);
                return t;
            }
        };
        return tf;
    }
}

