/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.analysis.TokenTypeUtils;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;

@Bindable(prefix="StopWordLabelFilter")
public class StopWordLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    public boolean enabled = true;

    public boolean acceptPhrase(PreprocessingContext context, int phraseIndex) {
        short[] termTypes = context.allWords.type;
        int[] wordIndices = context.allPhrases.wordIndices[phraseIndex];
        return !TokenTypeUtils.isCommon(termTypes[wordIndices[0]]) && !TokenTypeUtils.isCommon(termTypes[wordIndices[wordIndices.length - 1]]);
    }

    public boolean acceptWord(PreprocessingContext context, int wordIndex) {
        return !TokenTypeUtils.isCommon(context.allWords.type[wordIndex]);
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

