/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.boss;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.boss.BossLanguageCodes;
import org.carrot2.source.boss.YSearchResponse;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.httpclient.HttpHeaders;
import org.carrot2.util.httpclient.HttpUtils;
import org.carrot2.util.resource.URLResourceWithParams;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bindable(prefix="BossSearchService")
public abstract class BossSearchService {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final String CARROTSEARCH_APPID = "txRLTt7V34GgabH9baqIrsnRLuy87i4dQ2kQyok0IIqlUXdw4HmxjE59xhq2_6mT0LM-";
    public static final String YBOSS_RESPONSE = "boss.response";
    @Init
    @Input
    @Attribute
    public String appid = "txRLTt7V34GgabH9baqIrsnRLuy87i4dQ2kQyok0IIqlUXdw4HmxjE59xhq2_6mT0LM-";
    @Processing
    @Input
    @Attribute
    public String sites;
    @Input
    @Init
    @Processing
    @Attribute
    public BossLanguageCodes languageAndRegion;
    protected MultipageSearchEngineMetadata metadata = DEFAULT_METADATA;
    static final MultipageSearchEngineMetadata DEFAULT_METADATA = new MultipageSearchEngineMetadata(50, 1000);

    BossSearchService() {
    }

    protected abstract ArrayList<NameValuePair> createRequestParams(String var1, int var2, int var3);

    protected abstract String getServiceURI();

    protected final SearchEngineResponse query(String query, int start, int results) throws IOException {
        results = Math.min(results, this.metadata.resultsPerPage);
        ArrayList<NameValuePair> params = this.createRequestParams(query, start, results);
        params.add((NameValuePair)new BasicNameValuePair("appid", this.appid));
        params.add((NameValuePair)new BasicNameValuePair("start", Integer.toString(start)));
        params.add((NameValuePair)new BasicNameValuePair("count", Integer.toString(results)));
        params.add((NameValuePair)new BasicNameValuePair("format", "xml"));
        params.add((NameValuePair)new BasicNameValuePair("sites", this.sites));
        if (this.languageAndRegion != null) {
            try {
                params.add((NameValuePair)new BasicNameValuePair("lang", this.languageAndRegion.langCode));
                params.add((NameValuePair)new BasicNameValuePair("region", this.languageAndRegion.regionCode));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Language value: " + this.languageAndRegion);
            }
        }
        String serviceURI = BossSearchService.substituteAttributes(this.getServiceURI(), new NameValuePair[]{new BasicNameValuePair("query", query)});
        HttpUtils.Response response = HttpUtils.doGET(serviceURI, params, Arrays.asList(HttpHeaders.USER_AGENT_HEADER_MOZILLA));
        int statusCode = response.status;
        if (statusCode == 200 || statusCode == 503 || statusCode == 400) {
            SearchEngineResponse ser = this.parseResponseXML(response.getPayloadAsStream());
            ser.metadata.put("compression", response.compression);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Received, results: " + ser.results.size() + ", total: " + ser.getResultsTotal());
            }
            return ser;
        }
        String m = "BOSS returned HTTP Error: " + statusCode + ", HTTP payload: " + new String(response.payload, "iso8859-1");
        this.logger.warn(m);
        throw new IOException(m);
    }

    private static String substituteAttributes(String parameterizedURL, NameValuePair ... pairs) {
        HashMap attributes = Maps.newHashMap();
        for (NameValuePair nameValue : pairs) {
            attributes.put(nameValue.getName(), nameValue.getValue());
        }
        return URLResourceWithParams.substituteAttributes(parameterizedURL, attributes);
    }

    private SearchEngineResponse parseResponseXML(InputStream is) throws IOException {
        try {
            SearchEngineResponse response = new SearchEngineResponse();
            YSearchResponse yresponse = (YSearchResponse)new Persister().read(YSearchResponse.class, is);
            response.metadata.put(YBOSS_RESPONSE, yresponse);
            yresponse.populate(response, this.languageAndRegion != null ? this.languageAndRegion.toLanguageCode() : null);
            return response;
        }
        catch (Exception e0) {
            throw ExceptionUtils.wrapAs(IOException.class, e0);
        }
    }
}

