/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Document;
import org.carrot2.util.MapUtils;
import org.carrot2.util.StringUtils;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Root(name="group", strict=false)
@JsonAutoDetect(value={JsonMethod.NONE})
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public final class Cluster {
    public static final String OTHER_TOPICS = "other-topics";
    public static final String OTHER_TOPICS_LABEL = "Other Topics";
    public static final String SCORE = "score";
    @Attribute(required=false)
    Integer id;
    @ElementList(required=false, name="title", entry="phrase")
    private ArrayList<String> phrases = new ArrayList();
    private List<String> phrasesView = Collections.unmodifiableList(this.phrases);
    @ElementList(required=false, inline=true)
    private ArrayList<Cluster> subclusters = new ArrayList();
    private List<Cluster> subclustersView = Collections.unmodifiableList(this.subclusters);
    private final ArrayList<Document> documents = new ArrayList();
    private final List<Document> documentsView = Collections.unmodifiableList(this.documents);
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, Object> attributesView = Collections.unmodifiableMap(this.attributes);
    private String labelCache = null;
    private List<Document> allDocuments;
    @ElementMap(entry="attribute", key="key", attribute=true, inline=true, required=false)
    private HashMap<String, SimpleXmlWrapperValue> otherAttributesForSerialization;
    @ElementList(required=false, inline=true)
    List<DocumentRefid> documentIds;
    public static final Comparator<Cluster> BY_SIZE_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)new Function<Cluster, Integer>(){

        public Integer apply(Cluster cluster) {
            return cluster.size();
        }
    });
    public static final Comparator<Cluster> BY_SCORE_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)new Function<Cluster, Double>(){

        public Double apply(Cluster cluster) {
            return (Double)cluster.getAttribute(Cluster.SCORE);
        }
    });
    public static final Comparator<Cluster> BY_LABEL_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)new Function<Cluster, String>(){

        public String apply(Cluster cluster) {
            return cluster.getLabel();
        }
    });
    public static final Comparator<Cluster> BY_REVERSED_SIZE_AND_LABEL_COMPARATOR = Ordering.from(Collections.reverseOrder(BY_SIZE_COMPARATOR)).compound(BY_LABEL_COMPARATOR);
    public static final Comparator<Cluster> BY_REVERSED_SCORE_AND_LABEL_COMPARATOR = Ordering.from(Collections.reverseOrder(BY_SCORE_COMPARATOR)).compound(BY_LABEL_COMPARATOR);
    public static final Comparator<Cluster> OTHER_TOPICS_AT_THE_END = Ordering.natural().onResultOf((Function)new Function<Cluster, Double>(){

        public Double apply(Cluster cluster) {
            return cluster.isOtherTopics() ? 1.0 : -1.0;
        }
    });

    public Cluster() {
    }

    public Cluster(String phrase, Document ... documents) {
        this.addPhrases(phrase);
        this.addDocuments(documents);
    }

    public String getLabel() {
        if (this.labelCache == null) {
            this.labelCache = StringUtils.toString(this.phrases, ", ");
        }
        return this.labelCache;
    }

    @JsonProperty
    public List<String> getPhrases() {
        return this.phrasesView;
    }

    public List<Cluster> getSubclusters() {
        return this.subclustersView;
    }

    @JsonProperty(value="clusters")
    private List<Cluster> getSubclustersForSerialization() {
        return this.subclustersView.isEmpty() ? null : this.subclustersView;
    }

    public List<Document> getDocuments() {
        return this.documentsView;
    }

    public List<Document> getAllDocuments() {
        if (this.allDocuments == null) {
            this.allDocuments = new ArrayList<Document>(Cluster.collectAllDocuments(this, new LinkedHashSet<Document>()));
        }
        return this.allDocuments;
    }

    public List<Document> getAllDocuments(Comparator<Document> comparator) {
        ArrayList sortedDocuments = Lists.newArrayList(this.getAllDocuments());
        Collections.sort(sortedDocuments, comparator);
        return sortedDocuments;
    }

    private static Set<Document> collectAllDocuments(Cluster cluster, Set<Document> docs) {
        if (cluster == null) {
            return docs;
        }
        docs.addAll(cluster.getDocuments());
        List<Cluster> subclusters = cluster.getSubclusters();
        for (Cluster subcluster : subclusters) {
            Cluster.collectAllDocuments(subcluster, docs);
        }
        return docs;
    }

    public Cluster addPhrases(String ... phrases) {
        this.labelCache = null;
        for (String phrase : phrases) {
            this.phrases.add(phrase);
        }
        return this;
    }

    public Cluster addPhrases(Iterable<String> phrases) {
        this.labelCache = null;
        for (String phrase : phrases) {
            this.phrases.add(phrase);
        }
        return this;
    }

    public Cluster addDocuments(Document ... documents) {
        for (Document document : documents) {
            this.documents.add(document);
        }
        this.allDocuments = null;
        return this;
    }

    public Cluster addDocuments(Iterable<Document> documents) {
        for (Document document : documents) {
            this.documents.add(document);
        }
        this.allDocuments = null;
        return this;
    }

    public Cluster addSubclusters(Cluster ... subclusters) {
        for (Cluster cluster : subclusters) {
            this.subclusters.add(cluster);
        }
        this.allDocuments = null;
        return this;
    }

    public Cluster addSubclusters(Iterable<Cluster> clusters) {
        for (Cluster cluster : clusters) {
            this.subclusters.add(cluster);
        }
        this.allDocuments = null;
        return this;
    }

    @JsonProperty
    @Attribute(required=false)
    public Double getScore() {
        return (Double)this.getAttribute(SCORE);
    }

    @Attribute(required=false)
    public Cluster setScore(Double score) {
        return this.setAttribute(SCORE, score);
    }

    public <T> T getAttribute(String key) {
        return (T)this.attributes.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Cluster setAttribute(String key, T value) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.put(key, value);
        }
        return this;
    }

    public Map<String, Object> getAttributes() {
        return this.attributesView;
    }

    public int size() {
        return this.getAllDocuments().size();
    }

    @JsonProperty
    @Attribute(required=false)
    private int getSize() {
        return this.size();
    }

    @Attribute(required=false)
    private void setSize(int size) {
    }

    @JsonProperty
    public Integer getId() {
        return this.id;
    }

    public boolean isOtherTopics() {
        Boolean otherTopics = (Boolean)this.getAttribute(OTHER_TOPICS);
        return otherTopics != null && otherTopics != false;
    }

    public Cluster setOtherTopics(boolean isOtherTopics) {
        return this.setAttribute(OTHER_TOPICS, isOtherTopics).setScore(0.0);
    }

    public static Comparator<Cluster> byReversedWeightedScoreAndSizeComparator(final double scoreWeight) {
        if (scoreWeight < 0.0 || scoreWeight > 1.0) {
            throw new IllegalArgumentException("Score weight must be between 0.0 (inclusive) and 1.0 (inclusive) ");
        }
        return Ordering.natural().onResultOf((Function)new Function<Cluster, Double>(){

            public Double apply(Cluster cluster) {
                return -Math.pow(cluster.size(), 1.0 - scoreWeight) * Math.pow((Double)cluster.getAttribute(Cluster.SCORE), scoreWeight);
            }
        }).compound(BY_LABEL_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignClusterIds(Collection<Cluster> clusters) {
        ArrayList flattened = Lists.newArrayListWithExpectedSize((int)clusters.size());
        Cluster.flatten(flattened, clusters);
        Collection<Cluster> collection = clusters;
        synchronized (collection) {
            HashSet ids = Sets.newHashSet();
            int maxId = Integer.MIN_VALUE;
            for (Cluster cluster : flattened) {
                if (cluster.id == null) continue;
                if (!ids.add(cluster.id)) {
                    throw new IllegalArgumentException("Non-unique cluster id found: " + cluster.id);
                }
                maxId = Math.max(maxId, cluster.id);
            }
            maxId = Math.max(maxId, -1);
            for (Cluster c : flattened) {
                if (c.id != null) continue;
                c.id = ++maxId;
            }
        }
    }

    private static void flatten(ArrayList<Cluster> flattened, Collection<Cluster> clusters) {
        for (Cluster c : clusters) {
            flattened.add(c);
            List<Cluster> subclusters = c.getSubclusters();
            if (subclusters.isEmpty()) continue;
            Cluster.flatten(flattened, subclusters);
        }
    }

    public static Cluster find(int id, Collection<Cluster> clusters) {
        for (Cluster c : clusters) {
            Cluster sub;
            if (c == null) continue;
            if (c.id != null && c.id == id) {
                return c;
            }
            if (c.getSubclusters().isEmpty() || (sub = Cluster.find(id, c.getSubclusters())) == null) continue;
            return sub;
        }
        return null;
    }

    public static Cluster buildOtherTopics(List<Document> allDocuments, List<Cluster> clusters) {
        return Cluster.buildOtherTopics(allDocuments, clusters, OTHER_TOPICS_LABEL);
    }

    public static Cluster buildOtherTopics(List<Document> allDocuments, List<Cluster> clusters, String label) {
        LinkedHashSet unclusteredDocuments = Sets.newLinkedHashSet(allDocuments);
        HashSet assignedDocuments = Sets.newHashSet();
        for (Cluster cluster : clusters) {
            Cluster.collectAllDocuments(cluster, assignedDocuments);
        }
        unclusteredDocuments.removeAll(assignedDocuments);
        Cluster otherTopics = new Cluster(label, new Document[0]);
        otherTopics.addDocuments(unclusteredDocuments);
        otherTopics.setOtherTopics(true);
        return otherTopics;
    }

    public static void appendOtherTopics(List<Document> allDocuments, List<Cluster> clusters) {
        Cluster.appendOtherTopics(allDocuments, clusters, OTHER_TOPICS_LABEL);
    }

    public static void appendOtherTopics(List<Document> allDocuments, List<Cluster> clusters, String label) {
        Cluster otherTopics = Cluster.buildOtherTopics(allDocuments, clusters, label);
        if (!otherTopics.getDocuments().isEmpty()) {
            clusters.add(otherTopics);
        }
    }

    @Persist
    private void beforeSerialization() {
        this.documentIds = Lists.transform(this.documents, (Function)new Function<Document, DocumentRefid>(){

            public DocumentRefid apply(Document document) {
                return new DocumentRefid(document.getId());
            }
        });
        this.otherAttributesForSerialization = MapUtils.asHashMap(SimpleXmlWrappers.wrap(this.attributes));
        this.otherAttributesForSerialization.remove(SCORE);
        if (this.otherAttributesForSerialization.isEmpty()) {
            this.otherAttributesForSerialization = null;
        }
    }

    @Commit
    private void afterDeserialization() throws Exception {
        if (this.otherAttributesForSerialization != null) {
            this.attributes.putAll(SimpleXmlWrappers.unwrap(this.otherAttributesForSerialization));
        }
        this.phrasesView = Collections.unmodifiableList(this.phrases);
        this.subclustersView = Collections.unmodifiableList(this.subclusters);
    }

    @JsonProperty(value="documents")
    private List<Integer> getDocumentIds() {
        return Lists.transform(this.documents, (Function)Document.DocumentToId.INSTANCE);
    }

    @JsonProperty(value="attributes")
    private Map<String, Object> getOtherAttributes() {
        HashMap otherAttributes = Maps.newHashMap(this.attributesView);
        return otherAttributes.isEmpty() ? null : otherAttributes;
    }

    @Root(name="document")
    static class DocumentRefid {
        @Attribute
        Integer refid;

        DocumentRefid() {
        }

        DocumentRefid(Integer refid) {
            this.refid = refid;
        }
    }
}

