/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.MP3Frame;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AudioFrame
implements MP3Frame {
    private String version;
    private int sampleRate;
    private int channels;

    public String getVersion() {
        return this.version;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public static boolean isAudioHeader(int h1, int h2, int h3, int h4) {
        if (h1 == -1 || h2 == -1 || h3 == -1 || h4 == -1) {
            return false;
        }
        return h1 == 255 && (h2 & 0x60) == 96;
    }

    public AudioFrame(InputStream stream, ContentHandler handler) throws IOException, SAXException, TikaException {
        this(-2, -2, -2, -2, stream);
    }

    public AudioFrame(int h1, int h2, int h3, int h4, InputStream in) throws IOException {
        if (h1 == -2 && h2 == -2 && h3 == -2 && h4 == -2) {
            h1 = in.read();
            h2 = in.read();
            h3 = in.read();
            h4 = in.read();
        }
        if (AudioFrame.isAudioHeader(h1, h2, h3, h4)) {
            this.version = "MPEG 3 Layer ";
            int layer = h2 >> 1 & 3;
            this.version = layer == 1 ? this.version + "III" : (layer == 2 ? this.version + "II" : (layer == 3 ? this.version + "I" : this.version + "(reserved)"));
            this.version = this.version + " Version ";
            int ver = h2 >> 3 & 3;
            this.version = ver == 0 ? this.version + "2.5" : (ver == 2 ? this.version + "2" : (ver == 3 ? this.version + "1" : this.version + "(reseved)"));
            int rate = h3 >> 2 & 3;
            switch (rate) {
                case 0: {
                    this.sampleRate = 11025;
                    break;
                }
                case 1: {
                    this.sampleRate = 12000;
                    break;
                }
                default: {
                    this.sampleRate = 8000;
                }
            }
            if (ver == 2) {
                this.sampleRate *= 2;
            } else if (ver == 3) {
                this.sampleRate *= 4;
            }
            int chans = h4 & 3;
            this.channels = chans < 3 ? 2 : 1;
        } else {
            throw new IllegalArgumentException("Magic Audio Frame Header not found");
        }
    }
}

