/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DataIteratorAdapter;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.dt.point.PointObsDatasetImpl;
import ucar.nc2.dt.point.StationDatasetHelper;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StationObsDatasetImpl
extends PointObsDatasetImpl
implements StationObsDataset {
    protected StationDatasetHelper stationHelper;
    protected List<Station> stations = new ArrayList<Station>();

    public StationObsDatasetImpl() {
        this.stationHelper = new StationDatasetHelper(this);
    }

    public StationObsDatasetImpl(String title, String description, String location) {
        super(title, description, location);
        this.stationHelper = new StationDatasetHelper(this);
    }

    public StationObsDatasetImpl(NetcdfDataset ncfile) {
        super(ncfile);
        this.stationHelper = new StationDatasetHelper(this);
    }

    @Override
    public String getDetailInfo() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("StationObsDataset\n");
        sbuff.append(super.getDetailInfo());
        return sbuff.toString();
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.STATION;
    }

    @Override
    public Class getDataClass() {
        return StationObsDatatype.class;
    }

    @Override
    public List<Station> getStations() throws IOException {
        return this.getStations((CancelTask)null);
    }

    @Override
    public List<Station> getStations(CancelTask cancel) throws IOException {
        return this.stations;
    }

    @Override
    public List<Station> getStations(LatLonRect boundingBox) throws IOException {
        return this.getStations(boundingBox, null);
    }

    @Override
    public List<Station> getStations(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        return this.stationHelper.getStations(boundingBox, cancel);
    }

    @Override
    public Station getStation(String id) {
        return this.stationHelper.getStation(id);
    }

    @Override
    public int getStationDataCount(Station s) {
        StationImpl si = (StationImpl)s;
        return si.getNumObservations();
    }

    @Override
    public List getData(Station s) throws IOException {
        return this.getData(s, null);
    }

    @Override
    public List getData(Station s, Date start, Date end) throws IOException {
        return this.getData(s, start, end, null);
    }

    @Override
    public List getData(Station s, Date start, Date end, CancelTask cancel) throws IOException {
        double startTime = this.timeUnit.makeValue(start);
        double endTime = this.timeUnit.makeValue(end);
        return this.stationHelper.getStationObs(s, startTime, endTime, cancel);
    }

    @Override
    public List getData(List<Station> stations) throws IOException {
        return this.getData(stations, null);
    }

    @Override
    public List getData(List<Station> stations, CancelTask cancel) throws IOException {
        return this.stationHelper.getStationObs(stations, cancel);
    }

    @Override
    public List getData(List<Station> stations, Date start, Date end) throws IOException {
        return this.getData(stations, start, end, null);
    }

    @Override
    public List getData(List<Station> stations, Date start, Date end, CancelTask cancel) throws IOException {
        double startTime = this.timeUnit.makeValue(start);
        double endTime = this.timeUnit.makeValue(end);
        return this.stationHelper.getStationObs(stations, startTime, endTime, cancel);
    }

    @Override
    public List getData(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        return this.stationHelper.getStationObs(boundingBox, cancel);
    }

    @Override
    public List getData(LatLonRect boundingBox, Date start, Date end, CancelTask cancel) throws IOException {
        double startTime = this.timeUnit.makeValue(start);
        double endTime = this.timeUnit.makeValue(end);
        return this.stationHelper.getStationObs(boundingBox, startTime, endTime, cancel);
    }

    public void sortByTime(List<StationObsDatatype> stationObs) {
        this.stationHelper.sortByTime(stationObs);
    }

    @Override
    public DataIterator getDataIterator(Station s) {
        try {
            return new DataIteratorAdapter(this.getData(s).iterator());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DataIterator getDataIterator(Station s, Date start, Date end) {
        try {
            return new DataIteratorAdapter(this.getData(s, start, end).iterator());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

