/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.exception.BindVariableCommentIllegalParameterBeanSpecificationException;
import org.seasar.dbflute.twowaysql.exception.BindVariableCommentInScopeNotListException;
import org.seasar.dbflute.twowaysql.exception.BindVariableCommentParameterNullValueException;
import org.seasar.dbflute.twowaysql.exception.EmbeddedVariableCommentIllegalParameterBeanSpecificationException;
import org.seasar.dbflute.twowaysql.exception.EmbeddedVariableCommentInScopeNotListException;
import org.seasar.dbflute.twowaysql.exception.EmbeddedVariableCommentParameterNullValueException;
import org.seasar.dbflute.twowaysql.exception.InLoopOptionOutOfLoopException;
import org.seasar.dbflute.twowaysql.exception.LoopCurrentVariableOutOfForCommentException;
import org.seasar.dbflute.twowaysql.pmbean.ParameterBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeUtil {
    public static boolean isCurrentVariableOutOfScope(String firstName, boolean inLoop) {
        return !inLoop && firstName.equals("#current");
    }

    public static boolean isWrongParameterBeanName(String firstName, CommandContext ctx) {
        Object firstArg = ctx.getArg(firstName);
        return NodeUtil.isWrongParameterBeanName(firstName, firstArg);
    }

    public static boolean isWrongParameterBeanName(String firstName, Object firstArg) {
        return firstArg instanceof ParameterBean && !"pmb".equals(firstName);
    }

    public static void throwBindOrEmbeddedCommentParameterNullValueException(String expression, Class<?> targetType, String specifiedSql, boolean bind) {
        String name = bind ? "bind variable" : "embedded variable";
        String emmark = bind ? "" : "$";
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The value of " + name + " was null.");
        br.addItem("Advice");
        br.addElement("Is it within the scope of your assumption?");
        br.addElement("If the answer is YES, please confirm your application logic about the parameter.");
        br.addElement("If the answer is NO, please confirm the logic of parameter comment(especially IF comment).");
        br.addElement("For example:");
        br.addElement("  (x) - XXX_ID = /*" + emmark + "pmb.xxxId*/3");
        br.addElement("  (o) - /*IF pmb.xxxId != null*/XXX_ID = /*" + emmark + "pmb.xxxId*/3/*END*/");
        br.addItem("Comment Expression");
        br.addElement(expression);
        br.addItem("Parameter Type");
        br.addElement(targetType);
        br.addItem("Specified SQL");
        br.addElement(specifiedSql);
        String msg = br.buildExceptionMessage();
        if (bind) {
            throw new BindVariableCommentParameterNullValueException(msg);
        }
        throw new EmbeddedVariableCommentParameterNullValueException(msg);
    }

    public static void throwBindOrEmbeddedCommentInScopeNotListException(String expression, Class<?> targetType, String specifiedSql, boolean bind) {
        String emmark = bind ? "" : "$";
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The parameter for in-scope condition was not list or array.");
        br.addItem("Advice");
        br.addElement("If a style of a test value is, e.g. (2, 5, 7)',");
        br.addElement("the parameter should be list (collection) or array for in-scope.");
        br.addElement("For example:");
        br.addElement("  (x) - MEMBER_ID in /*" + emmark + "pmb.memberId*/('foo', 'bar')");
        br.addElement("  (o) - MEMBER_ID in /*" + emmark + "pmb.memberIdList*/('foo', 'bar')");
        br.addItem("Comment Expression");
        br.addElement(expression);
        br.addItem("Parameter Type");
        br.addElement(targetType);
        br.addItem("Specified SQL");
        br.addElement(specifiedSql);
        String msg = br.buildExceptionMessage();
        if (bind) {
            throw new BindVariableCommentInScopeNotListException(msg);
        }
        throw new EmbeddedVariableCommentInScopeNotListException(msg);
    }

    public static void throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException(String expression, String specifiedSql, boolean bind) {
        String name = bind ? "bind variable" : "embedded variable";
        String emmark = bind ? "" : "$";
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The " + name + " comment had the illegal parameter-bean specification.");
        br.addItem("Advice");
        br.addElement("At first, is it really " + name + " comment?");
        br.addElement("Have you had a spell miss?");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    /*IE pmb...*/");
        br.addElement("    /*FUOR pmb...*/");
        br.addElement("    /*BIGAN*/");
        br.addElement("  (o):");
        br.addElement("    /*IF pmb...*/");
        br.addElement("    /*FOR pmb...*/");
        br.addElement("    /*BEGIN*/");
        br.addElement("");
        br.addElement("If you want to set " + name + "comment,");
        br.addElement("confirm the spell of parameter-bean expression.");
        br.addElement("(using parameter-bean, it should be named 'pmb')");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    /*" + emmark + "pmb,memberId*/");
        br.addElement("    /*" + emmark + "p mb.memberId*/");
        br.addElement("    /*" + emmark + "pmb:memberId*/");
        br.addElement("    /*" + emmark + "pnb.memberId*/");
        br.addElement("  (o):");
        br.addElement("    /*" + emmark + "pmb.memberId*/");
        br.addItem("Comment Expression");
        br.addElement(expression);
        br.addItem("Specified SQL");
        br.addElement(specifiedSql);
        String msg = br.buildExceptionMessage();
        if (bind) {
            throw new BindVariableCommentIllegalParameterBeanSpecificationException(msg);
        }
        throw new EmbeddedVariableCommentIllegalParameterBeanSpecificationException(msg);
    }

    public static void throwBindOrEmbeddedCommentParameterEmptyListException(String expression, String specifiedSql, boolean bind) {
        String msg = "Look! Read the message below." + NodeUtil.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + NodeUtil.ln();
        msg = msg + "The list of " + (bind ? "bind" : "embedded") + " variable was empty." + NodeUtil.ln();
        msg = msg + NodeUtil.ln();
        msg = msg + "[Advice]" + NodeUtil.ln();
        msg = msg + "Please confirm your application logic." + NodeUtil.ln();
        msg = msg + "For example:" + NodeUtil.ln();
        msg = msg + "  (x):" + NodeUtil.ln();
        msg = msg + "    List<Integer> xxxIdList = new ArrayList<Integer>();" + NodeUtil.ln();
        msg = msg + "    cb.query().setXxxId_InScope(xxxIdList);// Or pmb.setXxxIdList(xxxIdList);" + NodeUtil.ln();
        msg = msg + "  (o):" + NodeUtil.ln();
        msg = msg + "    List<Integer> xxxIdList = new ArrayList<Integer>();" + NodeUtil.ln();
        msg = msg + "    xxxIdList.add(3);" + NodeUtil.ln();
        msg = msg + "    xxxIdList.add(7);" + NodeUtil.ln();
        msg = msg + "    cb.query().setXxxId_InScope(xxxIdList);// Or pmb.setXxxIdList(xxxIdList);" + NodeUtil.ln();
        msg = msg + NodeUtil.ln();
        msg = msg + "[Comment Expression]" + NodeUtil.ln() + expression + NodeUtil.ln();
        msg = msg + NodeUtil.ln();
        msg = msg + "[Specified SQL]" + NodeUtil.ln() + specifiedSql + NodeUtil.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IllegalStateException(msg);
    }

    public static void throwBindOrEmbeddedCommentParameterNullOnlyListException(String expression, String specifiedSql, boolean bind) {
        String msg = "Look! Read the message below." + NodeUtil.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + NodeUtil.ln();
        msg = msg + "The list of " + (bind ? "bind" : "embedded") + " variable was null-only list." + NodeUtil.ln();
        msg = msg + NodeUtil.ln();
        msg = msg + "[Advice]" + NodeUtil.ln();
        msg = msg + "Please confirm your application logic." + NodeUtil.ln();
        msg = msg + "For example:" + NodeUtil.ln();
        msg = msg + "  (x):" + NodeUtil.ln();
        msg = msg + "    List<Integer> xxxIdList = new ArrayList<Integer>();" + NodeUtil.ln();
        msg = msg + "    xxxIdList.add(null);" + NodeUtil.ln();
        msg = msg + "    xxxIdList.add(null);" + NodeUtil.ln();
        msg = msg + "    cb.query().setXxxId_InScope(xxxIdList);// Or pmb.setXxxIdList(xxxIdList);" + NodeUtil.ln();
        msg = msg + "  (o):" + NodeUtil.ln();
        msg = msg + "    List<Integer> xxxIdList = new ArrayList<Integer>();" + NodeUtil.ln();
        msg = msg + "    xxxIdList.add(3);" + NodeUtil.ln();
        msg = msg + "    xxxIdList.add(7);" + NodeUtil.ln();
        msg = msg + "    cb.query().setXxxId_InScope(xxxIdList);// Or pmb.setXxxIdList(xxxIdList);" + NodeUtil.ln();
        msg = msg + NodeUtil.ln();
        msg = msg + "[Comment Expression]" + NodeUtil.ln() + expression + NodeUtil.ln();
        msg = msg + NodeUtil.ln();
        msg = msg + "[Specified SQL]" + NodeUtil.ln() + specifiedSql + NodeUtil.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IllegalStateException(msg);
    }

    public static void throwInLoopOptionOutOfLoopException(String expression, String specifiedSql, String option) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The in-loop option of variable comment was out of loop.");
        br.addItem("Advice");
        br.addElement("The in-loop options are supported in loop only.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    /*pmb.memberName:notLike*/");
        br.addElement("    /*FOR ...*/");
        br.addElement("    /*END*/");
        br.addElement("  (o):");
        br.addElement("    /*FOR ...*/");
        br.addElement("    /*pmb.memberName:notLike*/");
        br.addElement("    /*END*/");
        br.addItem("Comment Expression");
        br.addElement(expression);
        br.addItem("In-Loop Option");
        br.addElement(option);
        br.addItem("Specified SQL");
        br.addElement(specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new InLoopOptionOutOfLoopException(msg);
    }

    public static void throwLoopCurrentVariableOutOfForCommentException(String expression, String specifiedSql) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Loop's current variable was out of FOR comment scope.");
        br.addItem("Advice");
        br.addElement("Loop's current variables should be in FOR comment scope.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    /*#current*/");
        br.addElement("    /*FOR*/.../*END*/");
        br.addElement("  (o):");
        br.addElement("    /*FOR*/");
        br.addElement("    /*#current*/");
        br.addElement("    /*END*/");
        br.addItem("Comment Expression");
        br.addElement(expression);
        br.addItem("Specified SQL");
        br.addElement(specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new LoopCurrentVariableOutOfForCommentException(msg);
    }

    protected static String ln() {
        return DBFluteSystem.getBasicLn();
    }
}

