/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlhandler.TnAbstractBasicSqlHandler;
import org.seasar.dbflute.twowaysql.context.CommandContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnCommandContextHandler
extends TnAbstractBasicSqlHandler {
    protected final CommandContext _commandContext;
    protected List<TnPropertyType> _firstBoundPropTypeList;

    public TnCommandContextHandler(DataSource dataSource, StatementFactory statementFactory, String sql, CommandContext commandContext) {
        super(dataSource, statementFactory, sql);
        this.assertObjectNotNull("commandContext", commandContext);
        this._commandContext = commandContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object[] args) {
        Connection conn = this.getConnection();
        try {
            int n = this.doExecute(conn, this._commandContext);
            return n;
        }
        finally {
            this.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doExecute(Connection conn, CommandContext ctx) {
        this.logSql(ctx.getBindVariables(), this.getArgTypes(ctx.getBindVariables()));
        PreparedStatement ps = this.prepareStatement(conn);
        int ret = -1;
        try {
            Object[] bindVariables = ctx.getBindVariables();
            Class<?>[] bindVariableTypes = ctx.getBindVariableTypes();
            if (this.hasBoundPropertyTypeList()) {
                int index = this.bindFirstScope(conn, ps, bindVariables, bindVariableTypes);
                this.bindSecondScope(conn, ps, bindVariables, bindVariableTypes, index);
            } else {
                this.bindArgs(conn, ps, bindVariables, bindVariableTypes);
            }
            ret = this.executeUpdate(ps);
        }
        finally {
            this.close(ps);
        }
        return ret;
    }

    protected boolean hasBoundPropertyTypeList() {
        return this._firstBoundPropTypeList != null && !this._firstBoundPropTypeList.isEmpty();
    }

    protected int bindFirstScope(Connection conn, PreparedStatement ps, Object[] bindVariables, Class<?>[] bindVariableTypes) {
        ArrayList<Object> firstVariableList = new ArrayList<Object>();
        ArrayList<ValueType> firstValueTypeList = new ArrayList<ValueType>();
        int index = 0;
        for (TnPropertyType propertyType : this._firstBoundPropTypeList) {
            firstVariableList.add(bindVariables[index]);
            firstValueTypeList.add(propertyType.getValueType());
            ++index;
        }
        this.bindArgs(conn, ps, firstVariableList.toArray(), firstValueTypeList.toArray(new ValueType[0]));
        return index;
    }

    protected void bindSecondScope(Connection conn, PreparedStatement ps, Object[] bindVariables, Class<?>[] bindVariableTypes, int index) {
        this.bindArgs(conn, ps, bindVariables, bindVariableTypes, index);
    }

    public void setFirstBoundPropTypeList(List<TnPropertyType> firstBoundPropTypeList) {
        this._firstBoundPropTypeList = firstBoundPropTypeList;
    }
}

