/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.command;

import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.bhv.core.SqlExecutionCreator;
import org.seasar.dbflute.bhv.core.command.AbstractEntityCommand;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.dbflute.util.DfTypeUtil;

public abstract class AbstractQueryEntityCBCommand
extends AbstractEntityCommand {
    protected ConditionBean _conditionBean;

    public boolean isConditionBean() {
        return true;
    }

    public void beforeGettingSqlExecution() {
        this.assertStatus("beforeGettingSqlExecution");
        ConditionBean cb = this._conditionBean;
        ConditionBeanContext.setConditionBeanOnThread(cb);
    }

    public String buildSqlExecutionKey() {
        this.assertStatus("buildSqlExecutionKey");
        String main = this._tableDbName + ":" + this.getCommandName();
        String entityName = DfTypeUtil.toClassTitle(this._entity);
        String cbName = DfTypeUtil.toClassTitle(this._conditionBean);
        String type = "(" + (entityName != null ? entityName + ", " : "") + cbName + ")";
        return main + type;
    }

    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return new SqlExecutionCreator(){

            public SqlExecution createSqlExecution() {
                return AbstractQueryEntityCBCommand.this.createQueryEntityCBExecution();
            }
        };
    }

    protected abstract SqlExecution createQueryEntityCBExecution();

    public ConditionBean getConditionBean() {
        return this._conditionBean;
    }

    public String getOutsideSqlPath() {
        return null;
    }

    public OutsideSqlOption getOutsideSqlOption() {
        return null;
    }

    protected void assertStatus(String methodName) {
        super.assertStatus(methodName);
        this.assertConditionBeanProperty(methodName);
    }

    protected void assertConditionBeanProperty(String methodName) {
        if (this._conditionBean == null) {
            throw new IllegalStateException(this.buildAssertMessage("_conditionBean", methodName));
        }
    }

    public void setConditionBean(ConditionBean conditionBean) {
        this._conditionBean = conditionBean;
    }
}

