/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;

@Internal
public class Colorref
implements Cloneable {
    private int value;

    public Colorref() {
        this.value = -1;
    }

    public Colorref(byte[] data, int offset) {
        this.value = LittleEndian.getInt((byte[])data, (int)offset);
    }

    public Colorref(int value) {
        this.value = value;
    }

    public Colorref clone() throws CloneNotSupportedException {
        return new Colorref(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Colorref other = (Colorref)obj;
        return this.value == other.value;
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == -1;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public byte[] toByteArray() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Structure state (EMPTY) is not good for serialization");
        }
        byte[] bs = new byte[4];
        LittleEndian.putInt((byte[])bs, (int)0, (int)this.value);
        return bs;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[COLORREF] EMPTY";
        }
        return "[COLORREF] 0x" + Integer.toHexString(this.value);
    }
}

