/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.StopFilterFactory;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.QParser;

final class ExtendedAnalyzer
extends Analyzer {
    final Map<String, Analyzer> map = new HashMap<String, Analyzer>();
    final QParser parser;
    final Analyzer queryAnalyzer;
    public boolean removeStopFilter = false;

    public static TokenizerChain getQueryTokenizerChain(QParser parser, String fieldName) {
        FieldType ft = parser.getReq().getSchema().getFieldType(fieldName);
        Analyzer qa = ft.getQueryAnalyzer();
        return qa instanceof TokenizerChain ? (TokenizerChain)qa : null;
    }

    public static StopFilterFactory getQueryStopFilter(QParser parser, String fieldName) {
        TokenizerChain tcq = ExtendedAnalyzer.getQueryTokenizerChain(parser, fieldName);
        if (tcq == null) {
            return null;
        }
        TokenFilterFactory[] facs = tcq.getTokenFilterFactories();
        for (int i = 0; i < facs.length; ++i) {
            TokenFilterFactory tf = facs[i];
            if (!(tf instanceof StopFilterFactory)) continue;
            return (StopFilterFactory)tf;
        }
        return null;
    }

    public ExtendedAnalyzer(QParser parser) {
        this.parser = parser;
        this.queryAnalyzer = parser.getReq().getSchema().getQueryAnalyzer();
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        if (!this.removeStopFilter) {
            return this.queryAnalyzer.tokenStream(fieldName, reader);
        }
        Analyzer a = this.map.get(fieldName);
        if (a != null) {
            return a.tokenStream(fieldName, reader);
        }
        FieldType ft = this.parser.getReq().getSchema().getFieldType(fieldName);
        Analyzer qa = ft.getQueryAnalyzer();
        if (!(qa instanceof TokenizerChain)) {
            this.map.put(fieldName, qa);
            return qa.tokenStream(fieldName, reader);
        }
        TokenizerChain tcq = (TokenizerChain)qa;
        Analyzer ia = ft.getAnalyzer();
        if (ia == qa || !(ia instanceof TokenizerChain)) {
            this.map.put(fieldName, qa);
            return qa.tokenStream(fieldName, reader);
        }
        TokenizerChain tci = (TokenizerChain)ia;
        for (TokenFilterFactory tf : tci.getTokenFilterFactories()) {
            if (!(tf instanceof StopFilterFactory)) continue;
            this.map.put(fieldName, qa);
            return qa.tokenStream(fieldName, reader);
        }
        int stopIdx = -1;
        TokenFilterFactory[] facs = tcq.getTokenFilterFactories();
        for (int i = 0; i < facs.length; ++i) {
            TokenFilterFactory tf;
            tf = facs[i];
            if (!(tf instanceof StopFilterFactory)) continue;
            stopIdx = i;
            break;
        }
        if (stopIdx == -1) {
            this.map.put(fieldName, qa);
            return qa.tokenStream(fieldName, reader);
        }
        TokenFilterFactory[] newtf = new TokenFilterFactory[facs.length - 1];
        int j = 0;
        for (int i = 0; i < facs.length; ++i) {
            if (i == stopIdx) continue;
            newtf[j++] = facs[i];
        }
        TokenizerChain newa = new TokenizerChain(tcq.getTokenizerFactory(), newtf);
        newa.setPositionIncrementGap(tcq.getPositionIncrementGap(fieldName));
        this.map.put(fieldName, newa);
        return newa.tokenStream(fieldName, reader);
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.queryAnalyzer.getPositionIncrementGap(fieldName);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (!this.removeStopFilter) {
            return this.queryAnalyzer.reusableTokenStream(fieldName, reader);
        }
        return this.tokenStream(fieldName, reader);
    }
}

