/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SampleEntry
extends AbstractBox
implements ContainerBox {
    private int dataReferenceIndex;
    protected List<Box> boxes = new LinkedList<Box>();
    byte[] type;

    protected SampleEntry(byte[] type) {
        super(type);
        this.type = type;
    }

    @Override
    public byte[] getType() {
        return this.type;
    }

    public void setType(byte[] type) {
        this.type = type;
    }

    public int getDataReferenceIndex() {
        return this.dataReferenceIndex;
    }

    @Override
    public void setBoxes(List<Box> boxes) {
        this.boxes = new LinkedList<Box>(boxes);
    }

    public void addBox(AbstractBox b) {
        this.boxes.add(b);
    }

    public boolean removeBox(Box b) {
        return this.boxes.remove(b);
    }

    @Override
    public List<Box> getBoxes() {
        return this.boxes;
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean recursive) {
        ArrayList<Box> boxesToBeReturned = new ArrayList<Box>(2);
        for (Box boxe : this.boxes) {
            if (clazz == boxe.getClass()) {
                boxesToBeReturned.add(boxe);
            }
            if (!recursive || !(boxe instanceof ContainerBox)) continue;
            boxesToBeReturned.addAll(((ContainerBox)boxe).getBoxes(clazz, recursive));
        }
        return boxesToBeReturned;
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        byte[] tmp = in.read(6);
        assert (Arrays.equals(new byte[6], tmp)) : "reserved byte not 0";
        this.dataReferenceIndex = in.readUInt16();
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        long sizeOfChildren = 0L;
        for (Box box : this.boxes) {
            sizeOfChildren += box.getSize();
        }
        return this.getSize() - sizeOfChildren;
    }
}

