/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.mdat;

import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFileConvenienceHelper;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.coremedia.iso.boxes.mdat.DummySortedMap;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleList
extends AbstractList<IsoBufferWrapper> {
    SortedMap<Long, Long> offsets2Sizes;
    List<Long> offsetKeys = null;
    IsoBufferWrapper isoBufferWrapper;

    private List<Long> getOffsetKeys() {
        if (this.offsetKeys == null) {
            ArrayList<Long> offsetKeys = new ArrayList<Long>(this.offsets2Sizes.size());
            for (Long aLong : this.offsets2Sizes.keySet()) {
                offsetKeys.add(aLong);
            }
            this.offsetKeys = offsetKeys;
        }
        return this.offsetKeys;
    }

    public SampleList(MovieFragmentBox moof) {
        assert (1 == moof.getTrackCount());
        this.offsets2Sizes = this.getOffsets(moof, moof.getTrackNumbers()[0]);
    }

    SortedMap<Long, Long> getOffsets(MovieFragmentBox moof, long trackId) {
        this.isoBufferWrapper = moof.getIsoFile().getOriginalIso();
        TreeMap<Long, Long> offsets2Sizes = new TreeMap<Long, Long>();
        List<TrackFragmentBox> traf = moof.getBoxes(TrackFragmentBox.class);
        assert (traf.size() == 1) : "I cannot deal with movie fragments containing more than one track fragment";
        for (TrackFragmentBox trackFragmentBox : traf) {
            if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
            long baseDataOffset = trackFragmentBox.getTrackFragmentHeaderBox().hasBaseDataOffset() ? trackFragmentBox.getTrackFragmentHeaderBox().getBaseDataOffset() : moof.getOffset();
            TrackRunBox trun = trackFragmentBox.getTrackRunBox();
            long sampleBaseOffset = baseDataOffset + (long)trun.getDataOffset();
            long[] sampleOffsets = trun.getSampleOffsets();
            long[] sampleSizes = trun.getSampleSizes();
            for (int i = 0; i < sampleSizes.length; ++i) {
                offsets2Sizes.put(sampleOffsets[i] + sampleBaseOffset, sampleSizes[i]);
            }
        }
        return offsets2Sizes;
    }

    public SampleList(TrackBox trackBox) {
        this.isoBufferWrapper = trackBox.getIsoFile().getOriginalIso();
        List<MovieExtendsBox> movieExtendsBoxes = trackBox.getParent().getBoxes(MovieExtendsBox.class);
        this.offsets2Sizes = new TreeMap<Long, Long>();
        if (movieExtendsBoxes.size() > 0) {
            List<TrackExtendsBox> trackExtendsBoxes = movieExtendsBoxes.get(0).getBoxes(TrackExtendsBox.class);
            for (TrackExtendsBox trackExtendsBox : trackExtendsBoxes) {
                if (trackExtendsBox.getTrackId() != trackBox.getTrackHeaderBox().getTrackId()) continue;
                for (MovieFragmentBox movieFragmentBox : trackBox.getIsoFile().getBoxes(MovieFragmentBox.class)) {
                    this.offsets2Sizes.putAll(this.getOffsets(movieFragmentBox, trackBox.getTrackHeaderBox().getTrackId()));
                }
                return;
            }
        }
        SampleSizeBox sampleSizeBox = SampleList.getSampleTableBox(trackBox).getSampleSizeBox();
        ChunkOffsetBox chunkOffsetBox = SampleList.getSampleTableBox(trackBox).getChunkOffsetBox();
        SampleToChunkBox sampleToChunkBox = SampleList.getSampleTableBox(trackBox).getSampleToChunkBox();
        long[] numberOfSamplesInChunk = sampleToChunkBox.blowup(chunkOffsetBox.getChunkOffsets().length);
        int sampleIndex = 0;
        if (sampleSizeBox.getSampleSize() > 0L) {
            this.offsets2Sizes = new DummySortedMap<Long, Long>(sampleSizeBox.getSampleSize());
        }
        for (int i = 0; i < numberOfSamplesInChunk.length; ++i) {
            long thisChunksNumberOfSamples = numberOfSamplesInChunk[i];
            long sampleOffset = chunkOffsetBox.getChunkOffsets()[i];
            int j = 0;
            while ((long)j < thisChunksNumberOfSamples) {
                long sampleSize = sampleSizeBox.getSampleSizeAtIndex(sampleIndex);
                this.offsets2Sizes.put(sampleOffset, sampleSize);
                sampleOffset += sampleSize;
                ++sampleIndex;
                ++j;
            }
        }
    }

    @Override
    public IsoBufferWrapper get(int index) {
        Long offset = this.getOffsetKeys().get(index);
        try {
            return this.isoBufferWrapper.getSegment(offset, (Long)this.offsets2Sizes.get(offset));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getOffset(int index) {
        Iterator<Long> entries = this.offsets2Sizes.keySet().iterator();
        Long entry = entries.next();
        while (index > 0) {
            --index;
            entry = entries.next();
        }
        return (Long)this.offsets2Sizes.get(entry);
    }

    @Override
    public int size() {
        return this.offsets2Sizes.size();
    }

    private static SampleTableBox getSampleTableBox(TrackBox trackBox) {
        return (SampleTableBox)IsoFileConvenienceHelper.get(trackBox, "mdia/minf/stbl");
    }
}

