/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class SchemeTypeBox
extends AbstractFullBox {
    public static final String TYPE = "schm";
    byte[] schemeType = new byte[4];
    long schemeVersion;
    String schemeUri = null;

    public SchemeTypeBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public byte[] getSchemeType() {
        return this.schemeType;
    }

    public String getFourCC() {
        return IsoFile.bytesToFourCC(this.schemeType);
    }

    public long getSchemeVersion() {
        return this.schemeVersion;
    }

    public String getSchemeUri() {
        return this.schemeUri;
    }

    public void setSchemeType(byte[] schemeType) {
        assert (schemeType != null && schemeType.length == 4) : "SchemeType may not be null or not 4 bytes long";
        this.schemeType = schemeType;
    }

    public void setSchemeVersion(int schemeVersion) {
        this.schemeVersion = schemeVersion;
    }

    public void setSchemeUri(String schemeUri) {
        this.schemeUri = schemeUri;
    }

    protected long getContentSize() {
        return 8 + ((this.getFlags() & 1) == 1 ? SchemeTypeBox.utf8StringLengthInBytes(this.schemeUri) + 1 : 0);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.schemeType[0] = (byte)in.readUInt8();
        this.schemeType[1] = (byte)in.readUInt8();
        this.schemeType[2] = (byte)in.readUInt8();
        this.schemeType[3] = (byte)in.readUInt8();
        this.schemeVersion = in.readUInt32();
        if ((this.getFlags() & 1) == 1) {
            this.schemeUri = in.readString();
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt8(this.schemeType[0]);
        isos.writeUInt8(this.schemeType[1]);
        isos.writeUInt8(this.schemeType[2]);
        isos.writeUInt8(this.schemeType[3]);
        isos.writeUInt32(this.schemeVersion);
        if ((this.getFlags() & 1) == 1) {
            isos.writeStringZeroTerm(this.schemeUri);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Schema Type Box[");
        buffer.append("schemeUri=").append(this.schemeUri).append("; ");
        buffer.append("schemeType=").append(IsoFile.bytesToFourCC(this.schemeType)).append("; ");
        buffer.append("schemeVersion=").append(this.schemeUri).append("; ");
        buffer.append("]");
        return buffer.toString();
    }
}

