/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FullContainerBox
extends AbstractFullBox
implements ContainerBox {
    protected List<Box> boxes = new LinkedList<Box>();

    @Override
    public void setBoxes(List<Box> boxes) {
        this.boxes = new LinkedList<Box>(boxes);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean recursive) {
        ArrayList<Box> boxesToBeReturned = new ArrayList<Box>(2);
        for (Box boxe : this.boxes) {
            if (clazz == boxe.getClass()) {
                boxesToBeReturned.add(boxe);
            }
            if (!recursive || !(boxe instanceof ContainerBox)) continue;
            boxesToBeReturned.addAll(((ContainerBox)boxe).getBoxes(clazz, recursive));
        }
        return boxesToBeReturned;
    }

    @Override
    protected long getContentSize() {
        long contentSize = 0L;
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    public void addBox(Box b) {
        this.boxes.add(b);
    }

    public void removeBox(Box b) {
        this.boxes.remove(b);
    }

    public FullContainerBox(String type) {
        super(IsoFile.fourCCtoBytes(type));
    }

    @Override
    public List<Box> getBoxes() {
        return this.boxes;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        long pos = in.position();
        int version = in.readUInt8();
        long flags = in.readUInt24();
        if (version > 3 && flags > 7L) {
            version = 0;
            flags = 0L;
            in.position(pos);
        }
        this.parseBoxes(size, in, boxParser, lastMovieFragmentBox);
    }

    protected void parseBoxes(long size, IsoBufferWrapper in, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        Box box;
        for (long remainingContentSize = size - 4L; remainingContentSize > 0L; remainingContentSize -= box.getSize()) {
            box = boxParser.parseBox(in, this, lastMovieFragmentBox);
            this.boxes.add(box);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FreeBox[");
        for (int i = 0; i < this.boxes.size(); ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(this.boxes.get(i).toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        for (Box boxe : this.boxes) {
            boxe.getBox(os);
        }
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        long sizeOfChildren = 0L;
        for (Box box : this.boxes) {
            sizeOfChildren += box.getSize();
        }
        return this.getSize() - sizeOfChildren;
    }
}

