/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.AbstractIsoBufferWrapper;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoBufferWrapperImpl;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class RandomAccessFileIsoBufferWrapperImpl
extends AbstractIsoBufferWrapper {
    RandomAccessFile raf;

    public RandomAccessFileIsoBufferWrapperImpl(File file) throws IOException {
        this.raf = new RandomAccessFile(file, "r");
    }

    public long position() throws IOException {
        return this.raf.getChannel().position();
    }

    public void position(long position) throws IOException {
        this.raf.seek(position);
    }

    public long size() {
        try {
            return this.raf.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] read(int byteCount) throws IOException {
        byte[] result = new byte[byteCount];
        this.read(result);
        return result;
    }

    public long remaining() throws IOException {
        return this.raf.length() - this.raf.getChannel().position();
    }

    public int read() throws IOException {
        return this.raf.read();
    }

    public int read(byte[] b) throws IOException {
        return this.raf.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        this.position(this.position() + n);
        return n;
    }

    public IsoBufferWrapper getSegment(long startPos, long length) throws IOException {
        assert (length < Integer.MAX_VALUE);
        long pos = this.raf.getFilePointer();
        byte[] bb = new byte[(int)length];
        this.raf.read(bb);
        this.raf.seek(pos);
        return new IsoBufferWrapperImpl(ByteBuffer.wrap(bb));
    }
}

