<tiles:insert template="/WEB-INF/view/common/admin/layout.jsp" flush="true">
	<tiles:put name="title"><bean:message key="labels.stats_configuration" /></tiles:put>
	<tiles:put name="header" value="/WEB-INF/view/common/admin/header.jsp" />
	<tiles:put name="footer" value="/WEB-INF/view/common/admin/footer.jsp" />
	<tiles:put name="menu" value="/WEB-INF/view/common/admin/menu.jsp" />
	<tiles:put name="menuType" value="stats" />
	<tiles:put name="headerScript" type="string">
<link rel="stylesheet" href="${f:url('/css/smoothness/jquery-ui-1.8.2.stats.css')}" type="text/css" media="all" />
<script type="text/javascript" src="${f:url('/js/admin/jquery-ui-1.8.2.stats.min.js')}"></script>
<script type="text/javascript" src="${f:url('/js/admin/stats.js')}"></script>
	</tiles:put>
	<tiles:put name="body" type="string">

      <div id="main">

<!-- Message: BEGIN -->
<div><html:messages id="msg" message="true"><bean:write name="msg" ignore="true"/></html:messages><html:errors/></div>
<!-- Message: END -->

<!-- Search: BEGIN -->
<div class="form-table">
<s:form>
<table>
	<tbody>
		<tr>
			<td>
				<table><tbody>
					<tr>
						<th style="width:100px;"><bean:message key="labels.stats_search_report_type"/></th>
						<td style="width:200px;">
						<html:select property="searchParams.reportType">
							<html:option value="searchWord"><bean:message key="labels.stats_search_word"/></html:option>
							<html:option value="searchQuery"><bean:message key="labels.stats_search_query"/></html:option>
							<html:option value="solrQuery"><bean:message key="labels.stats_solr_query"/></html:option>
							<html:option value="userAgent"><bean:message key="labels.stats_user_agent"/></html:option>
							<html:option value="referer"><bean:message key="labels.stats_referer"/></html:option>
							<html:option value="clientIp"><bean:message key="labels.stats_client_ip"/></html:option>
							<html:option value="clickUrl"><bean:message key="labels.stats_click_url"/></html:option>
						</html:select>
						</td>
					</tr>
					<tr>
						<th rowspan="2"><bean:message key="labels.stats_search_term"/></th>
						<td>
						<html:text property="searchParams.startDate" styleId="searchStartDate" size="10"></html:text>
						<html:select property="searchParams.startHour">
							<html:option value=""></html:option>
							<c:forEach begin="0" end="23" step="1" varStatus="status">
								<html:option value="${status.index}">${status.index}</html:option>
							</c:forEach>
						</html:select>
						:
						<html:select property="searchParams.startMin">
							<html:option value=""></html:option>
							<c:forEach begin="0" end="59" step="1" varStatus="status">
								<html:option value="${status.index}">${status.index}</html:option>
							</c:forEach>
						</html:select>
						</td>
					</tr>
					<tr>
						<td>
						<html:text property="searchParams.endDate" styleId="searchEndDate" size="10"></html:text>
						<html:select property="searchParams.endHour">
							<html:option value=""></html:option>
							<c:forEach begin="0" end="23" step="1" varStatus="status">
								<html:option value="${status.index}">${status.index}</html:option>
							</c:forEach>
						</html:select>
						:
						<html:select property="searchParams.endMin">
							<html:option value=""></html:option>
							<c:forEach begin="0" end="59" step="1" varStatus="status">
								<html:option value="${status.index}">${status.index}</html:option>
							</c:forEach>
						</html:select>
						</td>
					</tr>
				</tbody></table>
			</td>
			<td>
				<input type="submit" name="search" value="<bean:message key="labels.stats_button_search"/>"/>
				<input type="submit" name="reset" value="<bean:message key="labels.stats_button_reset"/>"/>
			</td>
		</tr>
	</tbody>
</table>
</s:form>
</div>
<!-- Search: END -->

<!-- List: BEGIN -->
<div class="list-table" style="margin-top:5px;">
<table border="1">
	<thead>
		<tr>
				<th style="text-align: center;width:400px;">
<c:if test="${searchParams.reportType=='searchWord'}"><bean:message key="labels.stats_search_word"/></c:if>
<c:if test="${searchParams.reportType=='searchQuery'}"><bean:message key="labels.stats_search_query"/></c:if>
<c:if test="${searchParams.reportType=='solrQuery'}"><bean:message key="labels.stats_solr_query"/></c:if>
<c:if test="${searchParams.reportType=='userAgent'}"><bean:message key="labels.stats_user_agent"/></c:if>
<c:if test="${searchParams.reportType=='referer'}"><bean:message key="labels.stats_referer"/></c:if>
<c:if test="${searchParams.reportType=='clientIp'}"><bean:message key="labels.stats_client_ip"/></c:if>
				</th>
				<th style="text-align: center;width:80px;">
<bean:message key="labels.stats_count"/>
				</th>
		</tr>
	</thead>
	<tbody>
		<c:forEach var="data" varStatus="s" items="${statsItems}">
		<tr class="${s.index % 2 == 0 ? 'row1' : 'row2'}">
								<td><div style="width:400px;overflow-x:auto;">${f:h(data.name)}</div></td>
								<td style="text-align:right;">${f:h(data.cnt)}</td>
		</tr>
		</c:forEach>
	</tbody>
</table>
<!-- Page Navigation: BEGIN -->
<div>
	<span>
		<c:if test="${statsPager.existPrePage}">
		<s:link href="list/${statsPager.currentPageNumber - 1}"><bean:message key="labels.crud_link_prev_page"/></s:link>
		</c:if>
	</span>
	<span>
		<c:forEach var="p" varStatus="s" items="${statsPager.pageNumberList}">
		<span>
			<c:if test="${p == statsPager.currentPageNumber}">
			${p}
			</c:if>
			<c:if test="${p != statsPager.currentPageNumber}">
			<s:link href="list/${p}">${p}</s:link>
			</c:if>
		</span>
		</c:forEach>
	</span>
	<span>
		<c:if test="${statsPager.existNextPage}">
		<s:link href="list/${statsPager.currentPageNumber + 1}"><bean:message key="labels.crud_link_next_page"/></s:link>
		</c:if>
	</span>
</div>
<div>
	<span>
		${statsPager.currentPageNumber}/${statsPager.allPageCount} (${statsPager.allRecordCount})
	</span>
</div>
<!-- Page Navigation: END -->
</div>
<!-- List: END -->

</div>

	</tiles:put>
</tiles:insert>
