/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.selector.impl;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.mobylet.charset.MobyletCharsetPool;
import org.mobylet.core.Carrier;
import org.mobylet.core.log.MobyletLogger;
import org.mobylet.core.selector.CharsetSelector;
import org.mobylet.core.util.SingletonUtils;

public class MobyletCharsetSelector
implements CharsetSelector {
    protected boolean isCharsetInstalled = false;
    protected boolean isCharsetNativeInstalled = false;
    protected Map<Carrier, Charset> charsetMap;

    public MobyletCharsetSelector() {
        this.initialize();
    }

    @Override
    public Charset getCharset(Carrier carrier) {
        if (this.isCharsetInstalled) {
            return this.charsetMap.get((Object)carrier);
        }
        return this.charsetMap.get((Object)Carrier.OTHER);
    }

    @Override
    public String getCharacterEncodingCharsetName(Carrier carrier) {
        if (this.isCharsetNativeInstalled) {
            return this.getCharsetName(carrier);
        }
        switch (carrier) {
            case DOCOMO: 
            case AU: {
                return "windows-31j";
            }
        }
        return this.getCharsetName(carrier);
    }

    @Override
    public String getCharsetName(Carrier carrier) {
        return this.getCharset(carrier).name();
    }

    @Override
    public boolean isCharsetInstalled() {
        return this.isCharsetInstalled;
    }

    protected void initialize() {
        MobyletLogger logger;
        this.charsetMap = new HashMap<Carrier, Charset>();
        Charset defCharset = SingletonUtils.get(Charset.class);
        if (defCharset == null) {
            defCharset = Charset.forName("windows-31j");
        }
        this.charsetMap.put(Carrier.OTHER, defCharset);
        try {
            this.charsetMap.put(Carrier.DOCOMO, MobyletCharsetPool.getInstance().charsetForName("x-mobylet-docomo"));
            this.charsetMap.put(Carrier.AU, MobyletCharsetPool.getInstance().charsetForName("x-mobylet-au"));
            this.charsetMap.put(Carrier.SOFTBANK, Charset.forName("utf-8"));
            logger = SingletonUtils.get(MobyletLogger.class);
            if (logger != null && logger.isLoggable()) {
                logger.log("[mobylet] mobylet-charset\u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u307e\u3057\u305f");
            }
            this.isCharsetInstalled = true;
        }
        catch (Throwable t) {
            MobyletLogger logger2 = SingletonUtils.get(MobyletLogger.class);
            if (logger2 != null && logger2.isLoggable()) {
                logger2.log("[mobylet] mobylet-charset\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
            }
            this.isCharsetInstalled = false;
        }
        try {
            Charset.forName("x-mobylet-docomo");
            Charset.forName("x-mobylet-au");
            logger = SingletonUtils.get(MobyletLogger.class);
            if (logger != null && logger.isLoggable()) {
                logger.log("[mobylet] mobylet-charset\u306fEXTDIR\u306b\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.isCharsetNativeInstalled = true;
        }
        catch (Throwable t) {
            this.isCharsetNativeInstalled = false;
        }
    }
}

