/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.ip;

import org.mobylet.core.MobyletRuntimeException;

public class IpAddress {
    protected String ipString;
    protected int ipStart;
    protected int ipEnd;
    protected int mask;

    public static int getIntegerIp(String ip) {
        String[] ipElements = ip.split("[.]");
        if (ipElements.length != 4) {
            throw new MobyletRuntimeException("IP\u30a2\u30c9\u30ec\u30b9\u306e\u5f62\u5f0f\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059 = " + ip, null);
        }
        int ipInteger = 0;
        ipInteger = Integer.parseInt(ipElements[0]) << 24;
        ipInteger += Integer.parseInt(ipElements[1]) << 16;
        ipInteger += Integer.parseInt(ipElements[2]) << 8;
        return ipInteger += Integer.parseInt(ipElements[3]);
    }

    public IpAddress(String ip) {
        this.ipString = ip;
        int maskIndex = 0;
        maskIndex = ip.indexOf(47);
        if (maskIndex > 0) {
            this.mask = Integer.parseInt(ip.substring(maskIndex + 1).trim());
            this.ipString = ip.substring(0, maskIndex).trim();
        }
        int ipInteger = IpAddress.getIntegerIp(this.ipString);
        if (this.mask != 0) {
            this.ipStart = ipInteger & -1 << 32 - this.mask;
            this.ipEnd = ipInteger | -1 >>> this.mask;
        } else {
            this.ipStart = ipInteger;
            this.ipEnd = ipInteger;
        }
    }

    public boolean containsIp(String ip) {
        return this.containsIp(IpAddress.getIntegerIp(ip));
    }

    public boolean containsIp(int ipInteger) {
        return this.ipStart <= ipInteger && ipInteger <= this.ipEnd;
    }

    public String getIpString() {
        return this.ipString;
    }
}

