/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.analytics.impl;

import java.util.Properties;
import java.util.regex.Pattern;
import org.mobylet.core.analytics.UniqueUserKey;
import org.mobylet.core.config.MobyletInjectionConfig;
import org.mobylet.core.util.StringUtils;

public class GoogleAnalyticsConfig
extends MobyletInjectionConfig {
    public static final String KEY_USE_JS = "analytics.use.js";
    public static final String KEY_MAXTHREAD = "analytics.max.thread";
    public static final String KEY_MAXSESSION = "analytics.max.session";
    public static final String KEY_TIMEOUT = "analytics.connection.timeout";
    public static final String KEY_UUKEY = "analytics.uniqueuser.key";
    public static final String KEY_HEADER_REQUESTURL = "analytics.header.requesturl";
    public static final String KEY_CRAWLER_IGNORE = "analytics.crawler.is.ignore";
    public static final String KEY_CRAWLER_REGEX = "analytics.crawler.regex";
    public static final String KEY_MOBILE_CRAWLER_IGNORE = "analytics.mobile.crawler.is.ignore";
    public static final String KEY_MOBILE_CRAWLER_REGEX = "analytics.mobile.crawler.regex";
    public static final String REGEX_CRAWLER = ".*(Accoona|Alexa|Ask[.]com|Baiduspider[+]|BBSWriter|DotBot|Exabot|e-SocietyRobot|Feedfetcher-Google|findlinks|GameSpy|Gigabot|Googlebot|Grub|ichiro|Infoseek|Inktomi Slurp|livedoor|Mediapartners-Google|MJ12bot|msnbot|NaverBot|OutfoxBot|Scooter|Shim-Crawler|sogou spider|Speedy Spider|Steeler|Twiceler|W3C|Yahoo[!]|YahooFeedSeeker|YahooSeeker).*";
    public static final String REGEX_MOBILE_CRAWLER = ".*(Googlebot-Mobile|Mediapartners-Google|Y[!]J-SRD|mobile goo|livedoor-Yill|Hatena-Mobile-Gateway|moba-crawler).*";
    protected Boolean useJs;
    protected Integer maxThread;
    protected Integer connectionTimeout;
    protected Integer maxSession;
    protected UniqueUserKey uniqueUserKey;
    protected String requestUrlHeader;
    protected Boolean isIgnoreCrawler;
    protected Pattern regexCrawler;
    protected Boolean isIgnoreMobileCrawler;
    protected Pattern regexMobileCrawler;

    public GoogleAnalyticsConfig() {
        this.initialize();
    }

    public Boolean useJs() {
        return this.useJs;
    }

    public Integer getMaxThread() {
        return this.maxThread;
    }

    public Integer getMaxSession() {
        return this.maxSession;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public UniqueUserKey getUniqueUserKey() {
        return this.uniqueUserKey;
    }

    public String getRequestUrlHeader() {
        return this.requestUrlHeader;
    }

    public Boolean isIgnoreCrawler() {
        return this.isIgnoreCrawler;
    }

    public Pattern getRegexCrawler() {
        return this.regexCrawler;
    }

    public Boolean isIgnoreMobileCrawler() {
        return this.isIgnoreMobileCrawler;
    }

    public Pattern getRegexMobileCrawler() {
        return this.regexMobileCrawler;
    }

    protected void initialize() {
        String val;
        Properties config = this.getConfig();
        try {
            this.useJs = StringUtils.isEmpty(config.getProperty(KEY_USE_JS)) ? Boolean.valueOf(false) : Boolean.valueOf(config.getProperty(KEY_USE_JS));
        }
        catch (Exception e) {
            this.useJs = false;
        }
        try {
            val = config.getProperty(KEY_MAXTHREAD);
            this.maxThread = Integer.parseInt(val);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.maxThread == null) {
            this.maxThread = 0;
        }
        try {
            val = config.getProperty(KEY_MAXSESSION);
            this.maxSession = Integer.parseInt(val);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.maxSession == null) {
            this.maxSession = 8192;
        }
        try {
            val = config.getProperty(KEY_TIMEOUT);
            this.connectionTimeout = Integer.parseInt(val);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.connectionTimeout == null) {
            this.connectionTimeout = 15000;
        }
        try {
            val = config.getProperty(KEY_UUKEY);
            this.uniqueUserKey = UniqueUserKey.valueOf(val);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.uniqueUserKey == null) {
            this.uniqueUserKey = UniqueUserKey.GUID;
        }
        try {
            this.requestUrlHeader = config.getProperty(KEY_HEADER_REQUESTURL);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.isIgnoreCrawler = StringUtils.isEmpty(config.getProperty(KEY_CRAWLER_IGNORE)) ? Boolean.valueOf(true) : Boolean.valueOf(config.getProperty(KEY_CRAWLER_IGNORE));
        }
        catch (Exception e) {
            this.isIgnoreCrawler = true;
        }
        try {
            this.regexCrawler = Pattern.compile(config.getProperty(KEY_CRAWLER_REGEX));
        }
        catch (Exception e) {
            this.regexCrawler = Pattern.compile(REGEX_CRAWLER);
        }
        try {
            this.isIgnoreMobileCrawler = StringUtils.isEmpty(config.getProperty(KEY_MOBILE_CRAWLER_IGNORE)) ? Boolean.valueOf(true) : Boolean.valueOf(config.getProperty(KEY_MOBILE_CRAWLER_IGNORE));
        }
        catch (Exception e) {
            this.isIgnoreMobileCrawler = true;
        }
        try {
            this.regexMobileCrawler = Pattern.compile(config.getProperty(KEY_MOBILE_CRAWLER_REGEX));
        }
        catch (Exception e) {
            this.regexMobileCrawler = Pattern.compile(REGEX_MOBILE_CRAWLER);
        }
    }

    @Override
    public String getConfigName() {
        return "mobylet.analytics.properties";
    }
}

