/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.mobylet.charset.codemap.MobyletSjisCodeMap;

public abstract class MobyletEncoder
extends CharsetEncoder {
    protected MobyletEncoder(Charset cs) {
        super(cs, 2.0f, 2.0f);
    }

    protected byte encodeSingle(char c) {
        return (byte)c;
    }

    protected byte[] encodeStandard(char c) {
        int bi = MobyletSjisCodeMap.toByte(c);
        if (bi > 255) {
            byte[] b = new byte[]{(byte)((bi & 0xFF00) >> 8), (byte)(bi & 0xFF)};
            return b;
        }
        return new byte[]{(byte)bi};
    }

    protected abstract byte[] encodeEmojiDouble(char var1);

    protected abstract int getMinEmojiCode();

    protected abstract int getMaxEmojiCode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        int pos = in.position();
        try {
            while (in.hasRemaining()) {
                if (out.remaining() < 2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                char c = in.get();
                if (c < '\u00a2') {
                    out.put(this.encodeSingle(c));
                } else if (this.getMinEmojiCode() <= c && c <= this.getMaxEmojiCode()) {
                    out.put(this.encodeEmojiDouble(c));
                } else {
                    out.put(this.encodeStandard(c));
                }
                ++pos;
            }
        }
        finally {
            in.position(pos);
        }
        return CoderResult.UNDERFLOW;
    }
}

