/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.collector;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.solr.search.DocSet;

public class FilterCollector
extends Collector {
    private final DocSet filter;
    private final Collector delegate;
    private int docBase;
    private int matches;

    public FilterCollector(DocSet filter, Collector delegate) throws IOException {
        this.filter = filter;
        this.delegate = delegate;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }

    public void collect(int doc) throws IOException {
        ++this.matches;
        if (this.filter.exists(doc + this.docBase)) {
            this.delegate.collect(doc);
        }
    }

    public void setNextReader(IndexReader indexReader, int docBase) throws IOException {
        this.docBase = docBase;
        this.delegate.setNextReader(indexReader, docBase);
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.delegate.acceptsDocsOutOfOrder();
    }

    public int getMatches() {
        return this.matches;
    }

    public Collector getDelegate() {
        return this.delegate;
    }
}

