/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.client.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.DestroyMethod;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.MaxLengthExceededException;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.S2RobotContext;
import org.seasar.robot.client.AbstractS2RobotClient;
import org.seasar.robot.client.http.Authentication;
import org.seasar.robot.client.http.RequestHeader;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.entity.RobotsTxt;
import org.seasar.robot.helper.ContentLengthHelper;
import org.seasar.robot.helper.RobotsTxtHelper;
import org.seasar.robot.util.CrawlingParameterUtil;
import org.seasar.robot.util.StreamUtil;
import org.seasar.robot.util.TemporaryFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HcHttpClient
extends AbstractS2RobotClient {
    public static final String CONNECTION_TIMEOUT_PROPERTY = "connectionTimeout";
    public static final String STALE_CHECKING_ENABLED_PROPERTY = "staleCheckingEnabled";
    public static final String SO_TIMEOUT_PROPERTY = "soTimeout";
    public static final String LINGER_PROPERTY = "linger";
    public static final String CONNECTION_MANAGER_TIMEOUT_PROPERTY = "connectionManagerTimeout";
    public static final String PROXY_HOST_PROPERTY = "proxyHost";
    public static final String PROXY_PORT_PROPERTY = "proxyPort";
    public static final String PROXY_AUTH_SCHEME_PROPERTY = "proxyAuthScheme";
    public static final String PROXY_CREDENTIALS_PROPERTY = "proxyCredentials";
    public static final String USER_AGENT_PROPERTY = "userAgent";
    public static final String BASIC_AUTHENTICATIONS_PROPERTY = "basicAuthentications";
    public static final String REQUERT_HEADERS_PROPERTY = "requestHeaders";
    public static final String AUTH_SCHEME_FACTORIES_PROPERTY = "authSchemeFactories";
    private static final Logger logger = LoggerFactory.getLogger(HcHttpClient.class);
    @Binding(bindingType=BindingType.MAY)
    @Resource
    protected RobotsTxtHelper robotsTxtHelper;
    @Binding(bindingType=BindingType.MAY)
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    public Integer connectionTimeout;
    public Integer maxTotalConnections;
    public Integer maxConnectionsPerRoute;
    public Boolean staleCheckingEnabled;
    public Integer soTimeout;
    public Integer linger;
    public Integer connectionManagerTimeout;
    public String cookiePolicy;
    public String userAgent = "S2Robot";
    protected volatile DefaultHttpClient httpClient;
    public HttpContext httpClientContext = new BasicHttpContext();
    public String proxyHost;
    public Integer proxyPort;
    public AuthScheme proxyAuthScheme = new BasicScheme();
    @Binding(bindingType=BindingType.MAY)
    public Credentials proxyCredentials;
    public int responseBodyInMemoryThresholdSize = 0x100000;
    private final List<Header> requestHeaderList = new ArrayList<Header>();
    public String defaultMimeType = "application/octet-stream";
    public CookieStore cookieStore = new BasicCookieStore();
    public ClientConnectionManager clientConnectionManager;
    public Map<String, AuthSchemeFactory> authSchemeFactoryMap;
    private boolean hasDigestAccess = false;

    public synchronized void init() {
        RequestHeader[] requestHeaders;
        Authentication[] siteCredentialList;
        String userAgent;
        Map<String, AuthSchemeFactory> authSchemeFactoryMap;
        Integer connectionManagerTimeout;
        Integer linger;
        Integer soTimeout;
        Boolean staleCheckingEnabled;
        if (this.httpClient != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing " + HcHttpClient.class.getName());
        }
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient(this.clientConnectionManager);
        HttpParams params = defaultHttpClient.getParams();
        Integer connectionTimeout = this.getInitParameter(CONNECTION_TIMEOUT_PROPERTY, this.connectionTimeout);
        if (connectionTimeout != null) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectionTimeout);
        }
        if ((staleCheckingEnabled = this.getInitParameter(STALE_CHECKING_ENABLED_PROPERTY, this.staleCheckingEnabled)) != null) {
            HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)staleCheckingEnabled);
        }
        if ((soTimeout = this.getInitParameter(SO_TIMEOUT_PROPERTY, this.soTimeout)) != null) {
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)soTimeout);
        }
        if ((linger = this.getInitParameter(LINGER_PROPERTY, this.linger)) != null) {
            HttpConnectionParams.setLinger((HttpParams)params, (int)linger);
        }
        if ((connectionManagerTimeout = this.getInitParameter(CONNECTION_MANAGER_TIMEOUT_PROPERTY, this.connectionManagerTimeout)) != null) {
            ConnManagerParams.setTimeout((HttpParams)params, (long)connectionManagerTimeout.intValue());
        }
        if ((authSchemeFactoryMap = this.getInitParameter(AUTH_SCHEME_FACTORIES_PROPERTY, this.authSchemeFactoryMap)) != null) {
            for (Map.Entry<String, AuthSchemeFactory> entry : authSchemeFactoryMap.entrySet()) {
                defaultHttpClient.getAuthSchemes().register(entry.getKey(), entry.getValue());
            }
        }
        BasicAuthCache authCache = new BasicAuthCache();
        boolean useAuthCache = false;
        String proxyHost = this.getInitParameter(PROXY_HOST_PROPERTY, this.proxyHost);
        Integer proxyPort = this.getInitParameter(PROXY_PORT_PROPERTY, this.proxyPort);
        if (proxyHost != null && proxyPort != null) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
            params.setParameter("http.route.default-proxy", (Object)proxy);
            Credentials proxyCredentials = this.getInitParameter(PROXY_CREDENTIALS_PROPERTY, this.proxyCredentials);
            if (proxyCredentials != null) {
                defaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), proxyCredentials);
                AuthScheme proxyAuthScheme = this.getInitParameter(PROXY_AUTH_SCHEME_PROPERTY, this.proxyAuthScheme);
                if (proxyAuthScheme != null) {
                    if ("Digest".equalsIgnoreCase(proxyAuthScheme.getSchemeName())) {
                        this.hasDigestAccess = true;
                    } else {
                        authCache.put(proxy, proxyAuthScheme);
                        useAuthCache = true;
                    }
                }
            }
        }
        if (StringUtil.isNotBlank((String)(userAgent = this.getInitParameter(USER_AGENT_PROPERTY, this.userAgent)))) {
            HttpProtocolParams.setUserAgent((HttpParams)params, (String)userAgent);
        }
        for (Authentication authentication : siteCredentialList = this.getInitParameter(BASIC_AUTHENTICATIONS_PROPERTY, new Authentication[0])) {
            AuthScope authScope = authentication.getAuthScope();
            defaultHttpClient.getCredentialsProvider().setCredentials(authScope, authentication.getCredentials());
            AuthScheme authScheme = authentication.getAuthScheme();
            if (authScope.getHost() == null || authScheme == null) continue;
            if ("Digest".equalsIgnoreCase(authScheme.getSchemeName())) {
                this.hasDigestAccess = true;
                continue;
            }
            HttpHost targetHost = new HttpHost(authScope.getHost(), authScope.getPort());
            authCache.put(targetHost, authScheme);
            useAuthCache = true;
        }
        if (useAuthCache) {
            this.httpClientContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        }
        for (RequestHeader requestHeader : requestHeaders = this.getInitParameter(REQUERT_HEADERS_PROPERTY, new RequestHeader[0])) {
            if (!requestHeader.isValid()) continue;
            this.requestHeaderList.add((Header)new BasicHeader(requestHeader.getName(), requestHeader.getValue()));
        }
        defaultHttpClient.getParams().setBooleanParameter("http.protocol.handle-redirects", false);
        defaultHttpClient.setCookieStore(this.cookieStore);
        this.httpClient = defaultHttpClient;
    }

    @DestroyMethod
    public void destroy() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    protected void processRobotsTxt(String url) {
        if (StringUtil.isBlank((String)url)) {
            throw new RobotSystemException("url is null or empty.");
        }
        if (this.robotsTxtHelper == null) {
            return;
        }
        S2RobotContext robotContext = CrawlingParameterUtil.getRobotContext();
        if (robotContext == null) {
            return;
        }
        int idx = url.indexOf(47, url.indexOf("://") + 3);
        String hostUrl = idx >= 0 ? url.substring(0, idx) : url;
        String robotTxtUrl = hostUrl + "/robots.txt";
        if (robotContext.getRobotTxtUrlSet().contains(robotTxtUrl)) {
            if (logger.isDebugEnabled()) {
                logger.debug(robotTxtUrl + " is already visited.");
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Checking URL: " + robotTxtUrl);
        }
        robotContext.getRobotTxtUrlSet().add(robotTxtUrl);
        HttpGet httpGet = new HttpGet(robotTxtUrl);
        if (this.cookiePolicy != null) {
            httpGet.getParams().setParameter("http.protocol.cookie-policy", (Object)this.cookiePolicy);
        }
        for (Header header : this.requestHeaderList) {
            httpGet.addHeader(header);
        }
        try {
            HttpResponse response = this.executeHttpClient((HttpUriRequest)httpGet);
            int httpStatusCode = response.getStatusLine().getStatusCode();
            if (httpStatusCode == 200) {
                HttpEntity httpEntity;
                Header contentLengthHeader = response.getFirstHeader("Content-Length");
                if (contentLengthHeader != null) {
                    long maxLength;
                    String value = contentLengthHeader.getValue();
                    long contentLength = Long.parseLong(value);
                    if (this.contentLengthHelper != null && contentLength > (maxLength = this.contentLengthHelper.getMaxLength("text/plain"))) {
                        throw new MaxLengthExceededException("The content length (" + contentLength + " byte) is over " + maxLength + " byte. The url is " + robotTxtUrl);
                    }
                }
                if ((httpEntity = response.getEntity()) != null) {
                    RobotsTxt.Directives directives;
                    RobotsTxt robotsTxt = this.robotsTxtHelper.parse(httpEntity.getContent());
                    if (robotsTxt != null && (directives = robotsTxt.getDirectives(this.userAgent)) != null) {
                        for (String urlPattern : directives.getDisallows()) {
                            if (!StringUtil.isNotBlank((String)urlPattern)) continue;
                            urlPattern = this.convertRobotsTxtPathPattern(urlPattern);
                            robotContext.getUrlFilter().addExclude(hostUrl + urlPattern);
                        }
                    }
                    httpEntity.consumeContent();
                }
            }
        }
        catch (RobotSystemException e) {
            httpGet.abort();
            throw e;
        }
        catch (Exception e) {
            httpGet.abort();
            throw new RobotCrawlAccessException("Could not process " + robotTxtUrl + ". ", e);
        }
    }

    protected String convertRobotsTxtPathPattern(String path) {
        String newPath = path.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
        if (newPath.charAt(0) != '/') {
            newPath = ".*" + newPath;
        }
        if (!newPath.endsWith("$") && !newPath.endsWith(".*")) {
            newPath = newPath + ".*";
        }
        return newPath.replaceAll("\\.\\*\\.\\*", ".*");
    }

    public ResponseData doGet(String url) {
        HttpGet httpGet;
        try {
            httpGet = new HttpGet(url);
        }
        catch (IllegalArgumentException e) {
            throw new RobotCrawlAccessException("The url may not be valid: " + url, e);
        }
        return this.doHttpMethod(url, (HttpUriRequest)httpGet);
    }

    public ResponseData doHead(String url) {
        HttpHead httpHead;
        try {
            httpHead = new HttpHead(url);
        }
        catch (IllegalArgumentException e) {
            throw new RobotCrawlAccessException("The url may not be valid: " + url, e);
        }
        return this.doHttpMethod(url, (HttpUriRequest)httpHead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData doHttpMethod(String url, HttpUriRequest httpRequest) {
        block46: {
            if (this.httpClient == null) {
                this.init();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Accessing " + url);
            }
            try {
                this.processRobotsTxt(url);
            }
            catch (RobotCrawlAccessException e) {
                if (logger.isInfoEnabled()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(e.getMessage());
                    if (e.getCause() != null) {
                        buf.append(e.getCause().getMessage());
                    }
                    logger.info(buf.toString());
                }
                if (!logger.isDebugEnabled()) break block46;
                logger.debug("Crawling Access Exception at " + url, (Throwable)e);
            }
        }
        if (this.cookiePolicy != null) {
            httpRequest.getParams().setParameter("http.protocol.cookie-policy", (Object)this.cookiePolicy);
        }
        for (Header header : this.requestHeaderList) {
            httpRequest.addHeader(header);
        }
        ResponseData responseData = null;
        InputStream inputStream = null;
        try {
            long maxLength;
            int idx;
            HttpResponse response = this.executeHttpClient(httpRequest);
            int httpStatusCode = response.getStatusLine().getStatusCode();
            if (httpStatusCode >= 300 && httpStatusCode < 400) {
                Header locationHeader = response.getFirstHeader("location");
                if (locationHeader == null) {
                    logger.warn("Invalid redirect location at " + url);
                } else {
                    responseData = new ResponseData();
                    responseData.setRedirectLocation(locationHeader.getValue());
                    return responseData;
                }
            }
            HttpEntity httpEntity = response.getEntity();
            long contentLength = 0L;
            String contentEncoding = "UTF-8";
            if (httpEntity == null) {
                inputStream = new ByteArrayInputStream(new byte[0]);
            } else {
                Header contentEncodingHeader;
                InputStream responseBodyStream = httpEntity.getContent();
                File outputFile = File.createTempFile("s2robot-CommonsHttpClient-", ".out");
                DeferredFileOutputStream dfos = null;
                try {
                    try {
                        dfos = new DeferredFileOutputStream(this.responseBodyInMemoryThresholdSize, outputFile);
                        StreamUtil.drain(responseBodyStream, (OutputStream)dfos);
                        dfos.flush();
                        Object var15_24 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_25 = null;
                        IOUtils.closeQuietly((OutputStream)dfos);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)dfos);
                    {
                    }
                }
                catch (Exception e) {
                    if (!outputFile.delete()) {
                        logger.warn("Could not delete " + outputFile.getAbsolutePath());
                    }
                    throw e;
                }
                if (dfos.isInMemory()) {
                    inputStream = new ByteArrayInputStream(dfos.getData());
                    contentLength = dfos.getData().length;
                    if (!outputFile.delete()) {
                        logger.warn("Could not delete " + outputFile.getAbsolutePath());
                    }
                } else {
                    inputStream = new TemporaryFileInputStream(outputFile);
                    contentLength = outputFile.length();
                }
                if ((contentEncodingHeader = httpEntity.getContentEncoding()) != null) {
                    contentEncoding = contentEncodingHeader.getValue();
                }
                httpEntity.consumeContent();
            }
            String contentType = null;
            Header contentTypeHeader = response.getFirstHeader("Content-Type");
            if (contentTypeHeader != null && (idx = (contentType = contentTypeHeader.getValue()).indexOf(59)) > 0) {
                contentType = contentType.substring(0, idx);
            }
            if (this.contentLengthHelper != null && contentLength > (maxLength = this.contentLengthHelper.getMaxLength(contentType))) {
                throw new MaxLengthExceededException("The content length (" + contentLength + " byte) is over " + maxLength + " byte. The url is " + url);
            }
            responseData = new ResponseData();
            responseData.setUrl(url);
            responseData.setCharSet(contentEncoding);
            if (httpRequest instanceof HttpHead) {
                responseData.setMethod("HEAD");
            } else {
                responseData.setMethod("GET");
            }
            responseData.setResponseBody(inputStream);
            responseData.setHttpStatusCode(httpStatusCode);
            for (Header header : response.getAllHeaders()) {
                responseData.addHeader(header.getName(), header.getValue());
            }
            if (contentType == null) {
                responseData.setMimeType(this.defaultMimeType);
            } else {
                responseData.setMimeType(contentType);
            }
            Header contentLengthHeader = response.getFirstHeader("Content-Length");
            if (contentLengthHeader == null) {
                responseData.setContentLength(contentLength);
            } else {
                String value = contentLengthHeader.getValue();
                try {
                    responseData.setContentLength(Long.parseLong(value));
                }
                catch (Exception e) {
                    responseData.setContentLength(contentLength);
                }
            }
            Header lastModifiedHeader = response.getFirstHeader("Last-Modified");
            if (lastModifiedHeader == null) {
                responseData.setLastModified(new Date());
            } else {
                String value = lastModifiedHeader.getValue();
                if (StringUtil.isNotBlank((String)value)) {
                    Date d = this.parseLastModified(value);
                    if (d == null) {
                        responseData.setLastModified(new Date());
                    } else {
                        responseData.setLastModified(d);
                    }
                }
            }
            return responseData;
        }
        catch (UnknownHostException e) {
            httpRequest.abort();
            IOUtils.closeQuietly(inputStream);
            throw new RobotCrawlAccessException("Unknown host(" + e.getMessage() + "): " + url, e);
        }
        catch (NoRouteToHostException e) {
            httpRequest.abort();
            IOUtils.closeQuietly(inputStream);
            throw new RobotCrawlAccessException("No route to host(" + e.getMessage() + "): " + url, e);
        }
        catch (ConnectException e) {
            httpRequest.abort();
            IOUtils.closeQuietly(inputStream);
            throw new RobotCrawlAccessException("Connection time out(" + e.getMessage() + "): " + url, e);
        }
        catch (SocketException e) {
            httpRequest.abort();
            IOUtils.closeQuietly(inputStream);
            throw new RobotCrawlAccessException("Socket exception(" + e.getMessage() + "): " + url, e);
        }
        catch (IOException e) {
            httpRequest.abort();
            IOUtils.closeQuietly(inputStream);
            throw new RobotCrawlAccessException("I/O exception(" + e.getMessage() + "): " + url, e);
        }
        catch (RobotSystemException e) {
            httpRequest.abort();
            IOUtils.closeQuietly(inputStream);
            throw e;
        }
        catch (Exception e) {
            httpRequest.abort();
            IOUtils.closeQuietly(inputStream);
            throw new RobotSystemException("Failed to access " + url, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeHttpClient(HttpUriRequest httpRequest) throws IOException, ClientProtocolException {
        if (this.hasDigestAccess) {
            DefaultHttpClient defaultHttpClient = this.httpClient;
            synchronized (defaultHttpClient) {
                return this.httpClient.execute(httpRequest, this.httpClientContext);
            }
        }
        return this.httpClient.execute(httpRequest, this.httpClientContext);
    }

    protected Date parseLastModified(String value) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        try {
            return sdf.parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

