/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfCollectionUtil {
    private static final List<?> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private static final Map<?, ?> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private static final Set<?> EMPTY_SET = Collections.unmodifiableSet(new HashSet());

    public static Class<?> findFirstElementType(Collection<?> collection) {
        for (Object object : collection) {
            if (object == null) continue;
            return object.getClass();
        }
        return null;
    }

    public static boolean hasValidElement(Collection<?> collection) {
        for (Object object : collection) {
            if (object == null) continue;
            return true;
        }
        return false;
    }

    public static <ELEMENT> ArrayList<ELEMENT> newArrayList() {
        return new ArrayList();
    }

    public static <ELEMENT> ArrayList<ELEMENT> newArrayList(Collection<ELEMENT> elements) {
        ArrayList<ELEMENT> list = DfCollectionUtil.newArrayList();
        list.addAll(elements);
        return list;
    }

    public static <ELEMENT> ArrayList<ELEMENT> newArrayList(ELEMENT ... elements) {
        ArrayList<ELEMENT> list = DfCollectionUtil.newArrayList();
        for (ELEMENT element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <ELEMENT> List<ELEMENT> emptyList() {
        return EMPTY_LIST;
    }

    public static <ELEMENT> List<List<ELEMENT>> splitByLimit(List<ELEMENT> elementList, int limit) {
        ArrayList<List<ELEMENT>> valueList = DfCollectionUtil.newArrayList();
        int valueSize = elementList.size();
        int index = 0;
        int remainderSize = valueSize;
        do {
            int beginIndex = limit * index;
            int endPoint = beginIndex + limit;
            int endIndex = limit <= remainderSize ? endPoint : valueSize;
            ArrayList<ELEMENT> splitList = DfCollectionUtil.newArrayList();
            splitList.addAll(elementList.subList(beginIndex, endIndex));
            valueList.add(splitList);
            remainderSize = valueSize - endIndex;
            ++index;
        } while (remainderSize > 0);
        return valueList;
    }

    public static <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    public static <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <KEY, VALUE> Map<KEY, VALUE> emptyMap() {
        return EMPTY_MAP;
    }

    public static <ELEMENT> HashSet<ELEMENT> newHashSet() {
        return new HashSet();
    }

    public static <ELEMENT> HashSet<ELEMENT> newHashSet(Collection<ELEMENT> elements) {
        HashSet<ELEMENT> set = DfCollectionUtil.newHashSet();
        set.addAll(elements);
        return set;
    }

    public static <ELEMENT> HashSet<ELEMENT> newHashSet(ELEMENT ... elements) {
        HashSet<ELEMENT> set = DfCollectionUtil.newHashSet();
        for (ELEMENT element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <ELEMENT> LinkedHashSet<ELEMENT> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <ELEMENT> LinkedHashSet<ELEMENT> newLinkedHashSet(Collection<ELEMENT> elements) {
        LinkedHashSet<ELEMENT> set = DfCollectionUtil.newLinkedHashSet();
        set.addAll(elements);
        return set;
    }

    public static <ELEMENT> LinkedHashSet<ELEMENT> newLinkedHashSet(ELEMENT ... elements) {
        LinkedHashSet<ELEMENT> set = DfCollectionUtil.newLinkedHashSet();
        for (ELEMENT element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <ELEMENT> Set<ELEMENT> emptySet() {
        return EMPTY_SET;
    }
}

