/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata.impl;

import java.lang.reflect.Field;
import org.seasar.dbflute.helper.beans.DfBeanDesc;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.util.DfReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnFieldBeanAnnotationReader
implements TnBeanAnnotationReader {
    public static final String TABLE = "TABLE";
    public static final String RELNO_SUFFIX = "_RELNO";
    public static final String RELKEYS_SUFFIX = "_RELKEYS";
    public static final String ID_SUFFIX = "_ID";
    public static final String NO_PERSISTENT_PROPS = "NO_PERSISTENT_PROPS";
    public static final String VERSION_NO_PROPERTY = "VERSION_NO_PROPERTY";
    public static final String TIMESTAMP_PROPERTY = "TIMESTAMP_PROPERTY";
    public static final String COLUMN_SUFFIX = "_COLUMN";
    public static final String VALUE_TYPE_SUFFIX = "_VALUE_TYPE";
    private DfBeanDesc _beanDesc;

    public TnFieldBeanAnnotationReader(Class<?> beanClass) {
        this._beanDesc = DfBeanDescFactory.getBeanDesc(beanClass);
    }

    @Override
    public String getColumnAnnotation(DfPropertyDesc pd) {
        String propertyName = pd.getPropertyName();
        String columnNameKey = propertyName + COLUMN_SUFFIX;
        return this.getField(columnNameKey);
    }

    @Override
    public String getTableAnnotation() {
        if (this._beanDesc.hasField(TABLE)) {
            Field field = this._beanDesc.getField(TABLE);
            return (String)DfReflectionUtil.getValue(field, null);
        }
        return null;
    }

    @Override
    public String getVersionNoPropertyName() {
        if (this._beanDesc.hasField(VERSION_NO_PROPERTY)) {
            Field field = this._beanDesc.getField(VERSION_NO_PROPERTY);
            return (String)DfReflectionUtil.getValue(field, null);
        }
        return null;
    }

    @Override
    public String getTimestampPropertyName() {
        if (this._beanDesc.hasField(TIMESTAMP_PROPERTY)) {
            Field field = this._beanDesc.getField(TIMESTAMP_PROPERTY);
            return (String)DfReflectionUtil.getValue(field, null);
        }
        return null;
    }

    @Override
    public String getId(DfPropertyDesc pd) {
        String id = this.getField(pd.getPropertyName() + ID_SUFFIX);
        if (id != null) {
            return id;
        }
        return this.getField(pd.getPropertyName() + ID_SUFFIX);
    }

    @Override
    public String getRelationKey(DfPropertyDesc pd) {
        String propertyName = pd.getPropertyName();
        String relkeysKey = propertyName + RELKEYS_SUFFIX;
        return this.getField(relkeysKey);
    }

    @Override
    public int getRelationNo(DfPropertyDesc pd) {
        String relnoKey = pd.getPropertyName() + RELNO_SUFFIX;
        Field field = this._beanDesc.getField(relnoKey);
        return (Integer)DfReflectionUtil.getValue(field, null);
    }

    @Override
    public boolean hasRelationNo(DfPropertyDesc pd) {
        String relnoKey = pd.getPropertyName() + RELNO_SUFFIX;
        return this._beanDesc.hasField(relnoKey);
    }

    @Override
    public String getValueType(DfPropertyDesc pd) {
        String valueTypeKey = pd.getPropertyName() + VALUE_TYPE_SUFFIX;
        return this.getField(valueTypeKey);
    }

    private String getField(String key) {
        if (this._beanDesc.hasField(key)) {
            Field field = this._beanDesc.getField(key);
            return (String)DfReflectionUtil.getValue(field, null);
        }
        return null;
    }
}

