/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.cvalue;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIXED_KEY_QUERY = "query";
    public static final String FIXED_KEY_INLINE = "inline";
    public static final String FIXED_KEY_ONCLAUSE = "onClause";
    protected Map<String, Map<String, Object>> _fixedValueMap;
    protected Map<String, Map<String, Object>> _varyingValueMap;
    protected boolean _orScopeQuery;
    protected boolean _inline;
    protected boolean _onClause;
    protected String _equalLatestLocation;
    protected transient ValueHandler _equalValueHandler;
    protected String _notEqualLatestLocation;
    protected transient ValueHandler _notEqualValueHandler;
    protected String _greaterThanLatestLocation;
    protected transient ValueHandler _greaterThanValueHandler;
    protected String _lessThanLatestLocation;
    protected transient ValueHandler _lessThanValueHandler;
    protected String _greaterEqualLatestLocation;
    protected transient ValueHandler _greaterEqualValueHandler;
    protected String _lessEqualLatestLocation;
    protected transient ValueHandler _lessEqualValueHandler;
    protected String _inScopeLatestLocation;
    protected transient ValueHandler _inScopeValueHandler;
    protected String _notInScopeLatestLocation;
    protected transient ValueHandler _notInScopeValueHandler;
    protected String _likeSearchLatestLocation;
    protected transient VaryingValueHandler _likeSearchValueHandler;
    protected String _notLikeSearchLatestLocation;
    protected transient VaryingValueHandler _notLikeSearchValueHandler;
    protected transient ValueHandler _isNotNullValueHandler;
    protected transient ValueHandler _isNullValueHandler;

    protected ValueHandler getEqualValueHandler() {
        if (this._equalValueHandler == null) {
            this._equalValueHandler = new StandardValueHandler(ConditionKey.CK_EQUAL);
        }
        return this._equalValueHandler;
    }

    public boolean hasEqual() {
        return this.getEqualValueHandler().hasValue();
    }

    public boolean equalEqual(Object value) {
        return this.getEqualValueHandler().equalValue(value);
    }

    public void overrideEqual(Object value) {
        this.getEqualValueHandler().overrideValue(value);
    }

    public void setupEqual(Object value, String location) {
        this._equalLatestLocation = location + "." + this.getEqualValueHandler().setValue(value);
    }

    public String getEqualLatestLocation() {
        return this._equalLatestLocation;
    }

    protected ValueHandler getNotEqualValueHandler() {
        if (this._notEqualValueHandler == null) {
            this._notEqualValueHandler = new StandardValueHandler(ConditionKey.CK_NOT_EQUAL_STANDARD);
        }
        return this._notEqualValueHandler;
    }

    public boolean hasNotEqual() {
        return this.getNotEqualValueHandler().hasValue();
    }

    public boolean equalNotEqual(Object value) {
        return this.getNotEqualValueHandler().equalValue(value);
    }

    public void overrideNotEqual(Object value) {
        this.getNotEqualValueHandler().overrideValue(value);
    }

    public void setupNotEqual(Object value, String location) {
        this._notEqualLatestLocation = location + "." + this.getNotEqualValueHandler().setValue(value);
    }

    public String getNotEqualLatestLocation() {
        return this._notEqualLatestLocation;
    }

    protected ValueHandler getGreaterThanValueHandler() {
        if (this._greaterThanValueHandler == null) {
            this._greaterThanValueHandler = new StandardValueHandler(ConditionKey.CK_GREATER_THAN);
        }
        return this._greaterThanValueHandler;
    }

    public boolean hasGreaterThan() {
        return this.getGreaterThanValueHandler().hasValue();
    }

    public boolean equalGreaterThan(Object value) {
        return this.getGreaterThanValueHandler().equalValue(value);
    }

    public void overrideGreaterThan(Object value) {
        this.getGreaterThanValueHandler().overrideValue(value);
    }

    public void setupGreaterThan(Object value, String location) {
        this._greaterThanLatestLocation = location + "." + this.getGreaterThanValueHandler().setValue(value);
    }

    public String getGreaterThanLatestLocation() {
        return this._greaterThanLatestLocation;
    }

    protected ValueHandler getLessThanValueHandler() {
        if (this._lessThanValueHandler == null) {
            this._lessThanValueHandler = new StandardValueHandler(ConditionKey.CK_LESS_THAN);
        }
        return this._lessThanValueHandler;
    }

    public boolean hasLessThan() {
        return this.getLessThanValueHandler().hasValue();
    }

    public boolean equalLessThan(Object value) {
        return this.getLessThanValueHandler().equalValue(value);
    }

    public void overrideLessThan(Object value) {
        this.getLessThanValueHandler().overrideValue(value);
    }

    public void setupLessThan(Object value, String location) {
        this._lessThanLatestLocation = location + "." + this.getLessThanValueHandler().setValue(value);
    }

    public String getLessThanLatestLocation() {
        return this._lessThanLatestLocation;
    }

    protected ValueHandler getGreaterEqualValueHandler() {
        if (this._greaterEqualValueHandler == null) {
            this._greaterEqualValueHandler = new StandardValueHandler(ConditionKey.CK_GREATER_EQUAL);
        }
        return this._greaterEqualValueHandler;
    }

    public boolean hasGreaterEqual() {
        return this.getGreaterEqualValueHandler().hasValue();
    }

    public boolean equalGreaterEqual(Object value) {
        return this.getGreaterEqualValueHandler().equalValue(value);
    }

    public void overrideGreaterEqual(Object value) {
        this.getGreaterEqualValueHandler().overrideValue(value);
    }

    public void setupGreaterEqual(Object value, String location) {
        this._greaterEqualLatestLocation = location + "." + this.getGreaterEqualValueHandler().setValue(value);
    }

    public String getGreaterEqualLatestLocation() {
        return this._greaterEqualLatestLocation;
    }

    protected ValueHandler getLessEqualValueHandler() {
        if (this._lessEqualValueHandler == null) {
            this._lessEqualValueHandler = new StandardValueHandler(ConditionKey.CK_LESS_EQUAL);
        }
        return this._lessEqualValueHandler;
    }

    public boolean hasLessEqual() {
        return this.getLessEqualValueHandler().hasValue();
    }

    public boolean equalLessEqual(Object value) {
        return this.getLessEqualValueHandler().equalValue(value);
    }

    public void overrideLessEqual(Object value) {
        this.getLessEqualValueHandler().overrideValue(value);
    }

    public void setupLessEqual(Object value, String location) {
        this._lessEqualLatestLocation = location + "." + this.getLessEqualValueHandler().setValue(value);
    }

    public String getLessEqualLatestLocation() {
        return this._lessEqualLatestLocation;
    }

    protected ValueHandler getInScopeValueHandler() {
        if (this._inScopeValueHandler == null) {
            this._inScopeValueHandler = new VaryingValueHandler(ConditionKey.CK_IN_SCOPE);
        }
        return this._inScopeValueHandler;
    }

    public void setupInScope(Object value, String location) {
        String key = this.getInScopeValueHandler().setValue(value);
        this._inScopeLatestLocation = location + "." + key;
    }

    public String getInScopeLatestLocation() {
        return this._inScopeLatestLocation;
    }

    protected ValueHandler getNotInScopeValueHandler() {
        if (this._notInScopeValueHandler == null) {
            this._notInScopeValueHandler = new VaryingValueHandler(ConditionKey.CK_NOT_IN_SCOPE);
        }
        return this._notInScopeValueHandler;
    }

    public void setupNotInScope(Object value, String location) {
        String key = this.getNotInScopeValueHandler().setValue(value);
        this._notInScopeLatestLocation = location + "." + key;
    }

    public String getNotInScopeLatestLocation() {
        return this._notInScopeLatestLocation;
    }

    protected VaryingValueHandler getLikeSearchValueHandler() {
        if (this._likeSearchValueHandler == null) {
            this._likeSearchValueHandler = new VaryingValueHandler(ConditionKey.CK_LIKE_SEARCH);
        }
        return this._likeSearchValueHandler;
    }

    public void setupLikeSearch(String value, LikeSearchOption option, String location) {
        String key = this.getLikeSearchValueHandler().setValue(option.generateRealValue(value));
        this._likeSearchLatestLocation = location + "." + key;
    }

    public String getLikeSearchLatestLocation() {
        return this._likeSearchLatestLocation;
    }

    protected VaryingValueHandler getNotLikeSearchValueHandler() {
        if (this._notLikeSearchValueHandler == null) {
            this._notLikeSearchValueHandler = new VaryingValueHandler(ConditionKey.CK_NOT_LIKE_SEARCH);
        }
        return this._notLikeSearchValueHandler;
    }

    public void setupNotLikeSearch(String value, LikeSearchOption option, String location) {
        String key = this.getNotLikeSearchValueHandler().setValue(option.generateRealValue(value));
        this._notLikeSearchLatestLocation = location + "." + key;
    }

    public String getNotLikeSearchLatestLocation() {
        return this._notLikeSearchLatestLocation;
    }

    protected ValueHandler getIsNotNullValueHandler() {
        if (this._isNotNullValueHandler == null) {
            this._isNotNullValueHandler = new StandardValueHandler(ConditionKey.CK_IS_NOT_NULL);
        }
        return this._isNotNullValueHandler;
    }

    public String setIsNotNull(Object value) {
        return this.getIsNotNullValueHandler().setValue(value);
    }

    public boolean hasIsNotNull() {
        return this.getIsNotNullValueHandler().hasValue();
    }

    protected ValueHandler getIsNullValueHandler() {
        if (this._isNullValueHandler == null) {
            this._isNullValueHandler = new StandardValueHandler(ConditionKey.CK_IS_NULL);
        }
        return this._isNullValueHandler;
    }

    public String setIsNull(Object value) {
        return this.getIsNullValueHandler().setValue(value);
    }

    public boolean hasIsNull() {
        return this.getIsNullValueHandler().hasValue();
    }

    protected Object getFixedValue(ConditionKey conditionKey) {
        if (!this.hasFixedValue(conditionKey)) {
            return null;
        }
        return this._fixedValueMap.get(this.getFixedValueKey()).get(conditionKey.getConditionKey());
    }

    protected String setupFixedValue(ConditionKey conditionKey, Object value) {
        String fixedValueKey;
        Map<String, Object> elementMap;
        if (this._fixedValueMap == null) {
            this._fixedValueMap = new HashMap<String, Map<String, Object>>(3);
        }
        if ((elementMap = this._fixedValueMap.get(fixedValueKey = this.getFixedValueKey())) == null) {
            elementMap = new HashMap<String, Object>(8);
            this._fixedValueMap.put(fixedValueKey, elementMap);
        }
        String key = conditionKey.getConditionKey();
        elementMap.put(key, value);
        return "fixed." + fixedValueKey + "." + key;
    }

    protected String getFixedValueKey() {
        if (this._inline) {
            if (this._onClause) {
                return FIXED_KEY_ONCLAUSE;
            }
            return FIXED_KEY_INLINE;
        }
        return FIXED_KEY_QUERY;
    }

    protected boolean hasFixedValue(ConditionKey conditionKey) {
        if (this._fixedValueMap == null) {
            return false;
        }
        Map<String, Object> elementMap = this._fixedValueMap.get(this.getFixedValueKey());
        if (elementMap == null) {
            return false;
        }
        return elementMap.containsKey(conditionKey.getConditionKey());
    }

    protected Object getVaryingValue(ConditionKey conditionKey) {
        throw new IllegalStateException();
    }

    protected String setupVaryingValue(ConditionKey conditionKey, Object value) {
        String key;
        Map<String, Object> elementMap;
        if (this._varyingValueMap == null) {
            this._varyingValueMap = new HashMap<String, Map<String, Object>>(4);
        }
        if ((elementMap = this._varyingValueMap.get(key = conditionKey.getConditionKey())) == null) {
            elementMap = new LinkedHashMap<String, Object>();
            this._varyingValueMap.put(key, elementMap);
        }
        String elementKey = key + elementMap.size();
        elementMap.put(elementKey, value);
        return "varying." + key + "." + elementKey;
    }

    protected boolean hasVaryingValue(ConditionKey conditionKey) {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RESULT> RESULT process(CallbackProcessor<RESULT> processor) {
        try {
            QueryModeProvider provider = processor.getProvider();
            this._orScopeQuery = provider.isOrScopeQuery();
            this._inline = provider.isInline();
            this._onClause = provider.isOnClause();
            RESULT RESULT = processor.process();
            return RESULT;
        }
        finally {
            this._orScopeQuery = false;
            this._inline = false;
            this._onClause = false;
        }
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        StringBuilder sb = new StringBuilder();
        sb.append(title).append(":{");
        sb.append("fixed=").append(this._fixedValueMap);
        sb.append(", varying=").append(this._varyingValueMap);
        sb.append("}");
        return sb.toString();
    }

    public boolean isFixedQuery() {
        return !this._orScopeQuery;
    }

    public Map<String, Map<String, Object>> getFixed() {
        return this._fixedValueMap;
    }

    public Map<String, Object> getFixedQuery() {
        return this._fixedValueMap != null ? this._fixedValueMap.get(FIXED_KEY_QUERY) : null;
    }

    public Map<String, Object> getFixedInline() {
        return this._fixedValueMap != null ? this._fixedValueMap.get(FIXED_KEY_INLINE) : null;
    }

    public Map<String, Object> getFixedOnClause() {
        return this._fixedValueMap != null ? this._fixedValueMap.get(FIXED_KEY_ONCLAUSE) : null;
    }

    public Map<String, Map<String, Object>> getVarying() {
        return this._varyingValueMap;
    }

    public static interface QueryModeProvider {
        public boolean isOrScopeQuery();

        public boolean isInline();

        public boolean isOnClause();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CallbackProcessor<RESULT> {
        public RESULT process();

        public QueryModeProvider getProvider();
    }

    protected class VaryingValueHandler
    implements ValueHandler {
        protected final ConditionKey _conditionKey;

        public VaryingValueHandler(ConditionKey conditionKey) {
            this._conditionKey = conditionKey;
        }

        public Object getValue() {
            return ConditionValue.this.getVaryingValue(this._conditionKey);
        }

        public String setValue(Object value) {
            return ConditionValue.this.setupVaryingValue(this._conditionKey, value);
        }

        public boolean hasValue() {
            return ConditionValue.this.hasVaryingValue(this._conditionKey);
        }

        public boolean equalValue(Object value) {
            return this.hasValue() ? this.getValue().equals(value) : value == null;
        }

        public void overrideValue(Object value) {
            this.setValue(value);
        }
    }

    protected class StandardValueHandler
    implements ValueHandler {
        protected final ConditionKey _conditionKey;

        public StandardValueHandler(ConditionKey conditionKey) {
            this._conditionKey = conditionKey;
        }

        public Object getValue() {
            return this.getStandardValue(this._conditionKey);
        }

        public String setValue(Object value) {
            return this.setupStandardValue(this._conditionKey, value);
        }

        public boolean hasValue() {
            return this.hasStandardValue(this._conditionKey);
        }

        public boolean equalValue(Object value) {
            return this.hasValue() ? this.getValue().equals(value) : value == null;
        }

        public void overrideValue(Object value) {
            this.setValue(value);
        }

        protected Object getStandardValue(ConditionKey conditionKey) {
            return ConditionValue.this._orScopeQuery ? ConditionValue.this.getVaryingValue(conditionKey) : ConditionValue.this.getFixedValue(conditionKey);
        }

        protected String setupStandardValue(ConditionKey conditionKey, Object value) {
            if (ConditionValue.this._orScopeQuery) {
                return ConditionValue.this.setupVaryingValue(conditionKey, value);
            }
            return ConditionValue.this.setupFixedValue(conditionKey, value);
        }

        protected boolean hasStandardValue(ConditionKey conditionKey) {
            return ConditionValue.this._orScopeQuery ? ConditionValue.this.hasVaryingValue(conditionKey) : ConditionValue.this.hasFixedValue(conditionKey);
        }
    }

    protected static interface ValueHandler {
        public Object getValue();

        public String setValue(Object var1);

        public boolean hasValue();

        public boolean equalValue(Object var1);

        public void overrideValue(Object var1);
    }
}

