/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.ckey;

import java.util.List;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClause;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClauseArranger;
import org.seasar.dbflute.cbean.sqlclause.query.StringQueryClause;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbway.ExtensionOperand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionKeyLikeSearch
extends ConditionKey {
    private static final long serialVersionUID = 1L;

    protected ConditionKeyLikeSearch() {
        this._conditionKey = this.defineConditionKey();
        this._operand = this.defineOperand();
    }

    protected String defineConditionKey() {
        return "likeSearch";
    }

    protected String defineOperand() {
        return "like";
    }

    @Override
    protected boolean doIsValidRegistration(ConditionValue cvalue, Object value, ColumnRealName callerName) {
        return value != null;
    }

    @Override
    protected void doAddWhereClause(List<QueryClause> conditionList, ColumnRealName columnRealName, ConditionValue value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doAddWhereClause(List<QueryClause> conditionList, ColumnRealName columnRealName, ConditionValue value, ConditionOption option) {
        QueryClause clause;
        this.assertWhereClauseArgument(columnRealName, value, option);
        String location = this.getLocation(value);
        LikeSearchOption myOption = (LikeSearchOption)option;
        String rearOption = myOption.getRearOption();
        String realOperand = this.getRealOperand(myOption);
        QueryClauseArranger arranger = myOption.getWhereClauseArranger();
        if (arranger != null) {
            String bindExpression = this.buildBindExpression(location, null);
            String arranged = arranger.arrange(columnRealName, realOperand, bindExpression, rearOption);
            clause = new StringQueryClause(arranged);
        } else {
            clause = this.buildBindClause(columnRealName, realOperand, location, rearOption);
        }
        conditionList.add(clause);
    }

    protected void assertWhereClauseArgument(ColumnRealName columnRealName, ConditionValue value, ConditionOption option) {
        if (option == null) {
            String msg = "The argument 'option' should not be null:";
            msg = msg + " columnName=" + columnRealName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (!(option instanceof LikeSearchOption)) {
            String msg = "The argument 'option' should be LikeSearchOption:";
            msg = msg + " columnName=" + columnRealName + " value=" + value;
            msg = msg + " option=" + option;
            throw new IllegalArgumentException(msg);
        }
    }

    protected String getLocation(ConditionValue value) {
        return value.getLikeSearchLatestLocation();
    }

    protected String getRealOperand(LikeSearchOption option) {
        ExtensionOperand extOperand = option.getExtensionOperand();
        String operand = extOperand != null ? extOperand.operand() : null;
        return operand != null ? operand : this.getOperand();
    }

    @Override
    protected void doSetupConditionValue(ConditionValue conditionValue, Object value, String location) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doSetupConditionValue(ConditionValue conditionValue, Object value, String location, ConditionOption option) {
        conditionValue.setupLikeSearch((String)value, (LikeSearchOption)option, location);
    }
}

