/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;

public class Overlay {
    public static final COSName XOBJECT = COSName.XOBJECT;
    public static final COSName PROC_SET = COSName.PROC_SET;
    public static final COSName EXT_G_STATE = COSName.EXT_G_STATE;
    private List layoutPages = new ArrayList(10);
    private PDDocument pdfOverlay;
    private PDDocument pdfDocument;
    private int pageCount = 0;
    private COSStream saveGraphicsStateStream;
    private COSStream restoreGraphicsStateStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, COSVisitorException {
        if (args.length != 3) {
            Overlay.usage();
            System.exit(1);
        } else {
            PDDocument overlay = null;
            PDDocument pdf = null;
            try {
                overlay = Overlay.getDocument(args[0]);
                pdf = Overlay.getDocument(args[1]);
                Overlay overlayer = new Overlay();
                overlayer.overlay(overlay, pdf);
                Overlay.writeDocument(pdf, args[2]);
            }
            finally {
                if (overlay != null) {
                    overlay.close();
                }
                if (pdf != null) {
                    pdf.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDocument(PDDocument pdf, String filename) throws IOException, COSVisitorException {
        FileOutputStream output = null;
        COSWriter writer = null;
        try {
            output = new FileOutputStream(filename);
            writer = new COSWriter(output);
            writer.write(pdf);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PDDocument getDocument(String filename) throws IOException {
        FileInputStream input = null;
        PDFParser parser = null;
        PDDocument result = null;
        try {
            input = new FileInputStream(filename);
            parser = new PDFParser(input);
            parser.parse();
            result = parser.getPDDocument();
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return result;
    }

    private static void usage() {
        System.err.println("usage: java " + Overlay.class.getName() + " <overlay.pdf> <document.pdf> <result.pdf>");
    }

    public PDDocument overlay(PDDocument overlay, PDDocument destination) throws IOException {
        this.pdfOverlay = overlay;
        this.pdfDocument = destination;
        PDDocumentCatalog overlayCatalog = this.pdfOverlay.getDocumentCatalog();
        this.collectLayoutPages(overlayCatalog.getAllPages());
        COSDictionary saveGraphicsStateDic = new COSDictionary();
        this.saveGraphicsStateStream = new COSStream(saveGraphicsStateDic, this.pdfDocument.getDocument().getScratchFile());
        OutputStream saveStream = this.saveGraphicsStateStream.createUnfilteredStream();
        saveStream.write(" q\n".getBytes("ISO-8859-1"));
        saveStream.flush();
        this.restoreGraphicsStateStream = new COSStream(saveGraphicsStateDic, this.pdfDocument.getDocument().getScratchFile());
        OutputStream restoreStream = this.restoreGraphicsStateStream.createUnfilteredStream();
        restoreStream.write(" Q\n".getBytes("ISO-8859-1"));
        restoreStream.flush();
        PDDocumentCatalog pdfCatalog = this.pdfDocument.getDocumentCatalog();
        this.processPages(pdfCatalog.getAllPages());
        return this.pdfDocument;
    }

    private void collectLayoutPages(List pages) throws IOException {
        for (PDPage page : pages) {
            COSBase contents = page.getCOSDictionary().getDictionaryObject(COSName.CONTENTS);
            PDResources resources = page.findResources();
            if (resources == null) {
                resources = new PDResources();
                page.setResources(resources);
            }
            COSDictionary res = resources.getCOSDictionary();
            if (contents instanceof COSStream) {
                COSStream stream = (COSStream)contents;
                TreeMap objectNameMap = new TreeMap();
                stream = this.makeUniqObjectNames(objectNameMap, stream);
                this.layoutPages.add(new LayoutPage(stream, res, objectNameMap));
                continue;
            }
            if (contents instanceof COSArray) {
                throw new UnsupportedOperationException("Layout pages with COSArray currently not supported.");
            }
            throw new IOException("Contents are unknown type:" + contents.getClass().getName());
        }
    }

    private COSStream makeUniqObjectNames(Map objectNameMap, COSStream stream) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
        byte[] buf = new byte[10240];
        InputStream is = stream.getUnfilteredStream();
        while ((read = is.read(buf)) > -1) {
            baos.write(buf, 0, read);
        }
        buf = baos.toByteArray();
        baos = new ByteArrayOutputStream(buf.length + 100);
        StringBuffer sbObjectName = new StringBuffer(10);
        boolean bInObjectIdent = false;
        boolean bInText = false;
        boolean bInEscape = false;
        for (int i = 0; i < buf.length; ++i) {
            byte b = buf[i];
            if (!bInEscape) {
                if (!bInText && b == 40) {
                    bInText = true;
                }
                if (bInText && b == 41) {
                    bInText = false;
                }
                if (b == 92) {
                    bInEscape = true;
                }
                if (!bInText && !bInEscape) {
                    if (b == 47) {
                        bInObjectIdent = true;
                    } else if (bInObjectIdent && Character.isWhitespace((char)b)) {
                        bInObjectIdent = false;
                        String objectName = sbObjectName.toString().substring(1);
                        String newObjectName = objectName + "overlay";
                        baos.write(47);
                        baos.write(newObjectName.getBytes("ISO-8859-1"));
                        objectNameMap.put(objectName, COSName.getPDFName(newObjectName));
                        sbObjectName.delete(0, sbObjectName.length());
                    }
                }
                if (bInObjectIdent) {
                    sbObjectName.append((char)b);
                    continue;
                }
            } else {
                bInEscape = false;
            }
            baos.write(b);
        }
        COSDictionary streamDict = new COSDictionary();
        streamDict.setInt(COSName.LENGTH, baos.size());
        COSStream output = new COSStream(streamDict, this.pdfDocument.getDocument().getScratchFile());
        output.setFilters(stream.getFilters());
        OutputStream os = output.createUnfilteredStream();
        baos.writeTo(os);
        os.close();
        return output;
    }

    private void processPages(List pages) throws IOException {
        for (PDPage page : pages) {
            COSDictionary pageDictionary = page.getCOSDictionary();
            COSBase contents = pageDictionary.getDictionaryObject(COSName.CONTENTS);
            if (contents instanceof COSStream) {
                COSStream contentsStream = (COSStream)contents;
                COSArray array = new COSArray();
                array.add(contentsStream);
                this.mergePage(array, page);
                pageDictionary.setItem(COSName.CONTENTS, (COSBase)array);
            } else if (contents instanceof COSArray) {
                COSArray contentsArray = (COSArray)contents;
                this.mergePage(contentsArray, page);
            } else {
                throw new IOException("Contents are unknown type:" + contents.getClass().getName());
            }
            ++this.pageCount;
        }
    }

    private void mergePage(COSArray array, PDPage page) {
        int layoutPageNum = this.pageCount % this.layoutPages.size();
        LayoutPage layoutPage = (LayoutPage)this.layoutPages.get(layoutPageNum);
        PDResources resources = page.findResources();
        if (resources == null) {
            resources = new PDResources();
            page.setResources(resources);
        }
        COSDictionary docResDict = resources.getCOSDictionary();
        COSDictionary layoutResDict = layoutPage.res;
        this.mergeArray(COSName.PROC_SET, docResDict, layoutResDict);
        this.mergeDictionary(COSName.FONT, docResDict, layoutResDict, layoutPage.objectNameMap);
        this.mergeDictionary(COSName.XOBJECT, docResDict, layoutResDict, layoutPage.objectNameMap);
        this.mergeDictionary(COSName.EXT_G_STATE, docResDict, layoutResDict, layoutPage.objectNameMap);
        array.add(0, this.saveGraphicsStateStream);
        array.add(this.restoreGraphicsStateStream);
        array.add(layoutPage.contents);
    }

    private void mergeDictionary(COSName name, COSDictionary dest, COSDictionary source, Map objectNameMap) {
        COSDictionary destDict = (COSDictionary)dest.getDictionaryObject(name);
        COSDictionary sourceDict = (COSDictionary)source.getDictionaryObject(name);
        if (destDict == null) {
            destDict = new COSDictionary();
            dest.setItem(name, (COSBase)destDict);
        }
        if (sourceDict != null) {
            for (Map.Entry<COSName, COSBase> entry : sourceDict.entrySet()) {
                COSName mappedKey = (COSName)objectNameMap.get(entry.getKey().getName());
                if (mappedKey == null) continue;
                destDict.setItem(mappedKey, entry.getValue());
            }
        }
    }

    private void mergeArray(COSName name, COSDictionary dest, COSDictionary source) {
        COSArray destDict = (COSArray)dest.getDictionaryObject(name);
        COSArray sourceDict = (COSArray)source.getDictionaryObject(name);
        if (destDict == null) {
            destDict = new COSArray();
            dest.setItem(name, (COSBase)destDict);
        }
        for (int sourceDictIdx = 0; sourceDict != null && sourceDictIdx < sourceDict.size(); ++sourceDictIdx) {
            COSBase key = sourceDict.get(sourceDictIdx);
            if (!(key instanceof COSName)) continue;
            COSName keyname = (COSName)key;
            boolean bFound = false;
            for (int destDictIdx = 0; destDictIdx < destDict.size(); ++destDictIdx) {
                COSName destkeyname;
                COSBase destkey = destDict.get(destDictIdx);
                if (!(destkey instanceof COSName) || !(destkeyname = (COSName)destkey).equals(keyname)) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            destDict.add(keyname);
        }
    }

    private static class LayoutPage {
        private final COSBase contents;
        private final COSDictionary res;
        private final Map objectNameMap;

        public LayoutPage(COSBase contentsValue, COSDictionary resValue, Map objectNameMapValue) {
            this.contents = contentsValue;
            this.res = resValue;
            this.objectNameMap = objectNameMapValue;
        }
    }
}

