/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.MessageBuilder;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.field.DefaultFieldParser;
import org.apache.james.mime4j.field.DelegatingFieldParser;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.message.EntityBuilder;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.message.MessageImpl;
import org.apache.james.mime4j.message.MultipartImpl;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageBuilder
implements MessageBuilder {
    private FieldParser<? extends ParsedField> fieldParser = null;
    private BodyFactory bodyFactory = null;
    private MimeConfig config = null;
    private BodyDescriptorBuilder bodyDescBuilder = null;
    private boolean contentDecoding = true;
    private boolean flatMode = false;
    private DecodeMonitor monitor = null;

    public void setFieldParser(FieldParser<? extends ParsedField> fieldParser) {
        this.fieldParser = fieldParser;
    }

    public void setBodyFactory(BodyFactory bodyFactory) {
        this.bodyFactory = bodyFactory;
    }

    public void setMimeEntityConfig(MimeConfig config) {
        this.config = config;
    }

    public void setBodyDescriptorBuilder(BodyDescriptorBuilder bodyDescBuilder) {
        this.bodyDescBuilder = bodyDescBuilder;
    }

    public void setDecodeMonitor(DecodeMonitor monitor) {
        this.monitor = monitor;
    }

    public void setContentDecoding(boolean contentDecoding) {
        this.contentDecoding = contentDecoding;
    }

    public void setFlatMode(boolean flatMode) {
        this.flatMode = flatMode;
    }

    public Header copy(Header other) {
        HeaderImpl copy = new HeaderImpl();
        for (Field otherField : other.getFields()) {
            copy.addField(otherField);
        }
        return copy;
    }

    public BodyPart copy(Entity other) {
        BodyPart copy = new BodyPart();
        if (other.getHeader() != null) {
            copy.setHeader(this.copy(other.getHeader()));
        }
        if (other.getBody() != null) {
            copy.setBody(this.copy(other.getBody()));
        }
        return copy;
    }

    public Multipart copy(Multipart other) {
        MultipartImpl copy = new MultipartImpl(other.getSubType());
        for (Entity otherBodyPart : other.getBodyParts()) {
            copy.addBodyPart(this.copy(otherBodyPart));
        }
        copy.setPreamble(other.getPreamble());
        copy.setEpilogue(other.getEpilogue());
        return copy;
    }

    public Body copy(Body body) {
        if (body == null) {
            throw new IllegalArgumentException("Body is null");
        }
        if (body instanceof Message) {
            return this.copy((Message)body);
        }
        if (body instanceof Multipart) {
            return this.copy((Multipart)body);
        }
        if (body instanceof SingleBody) {
            return ((SingleBody)body).copy();
        }
        throw new IllegalArgumentException("Unsupported body class");
    }

    public Message copy(Message other) {
        MessageImpl copy = new MessageImpl();
        if (other.getHeader() != null) {
            copy.setHeader(this.copy(other.getHeader()));
        }
        if (other.getBody() != null) {
            copy.setBody(this.copy(other.getBody()));
        }
        return copy;
    }

    @Override
    public Header newHeader() {
        return new HeaderImpl();
    }

    @Override
    public Header newHeader(Header source) {
        return this.copy(source);
    }

    @Override
    public Multipart newMultipart(String subType) {
        return new MultipartImpl(subType);
    }

    @Override
    public Multipart newMultipart(Multipart source) {
        return this.copy(source);
    }

    @Override
    public Header parseHeader(InputStream is) throws IOException, MimeIOException {
        DecodeMonitor mon;
        MimeConfig cfg = this.config != null ? this.config : new MimeConfig();
        boolean strict = cfg.isStrictParsing();
        DecodeMonitor decodeMonitor = this.monitor != null ? this.monitor : (mon = strict ? DecodeMonitor.STRICT : DecodeMonitor.SILENT);
        final DelegatingFieldParser fp = this.fieldParser != null ? this.fieldParser : (strict ? DefaultFieldParser.getParser() : LenientFieldParser.getParser());
        final HeaderImpl header = new HeaderImpl();
        final MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void endHeader() {
                parser.stop();
            }

            public void field(Field field) throws MimeException {
                ParsedField parsedField = field instanceof ParsedField ? (ParsedField)field : fp.parse(field, mon);
                header.addField(parsedField);
            }
        });
        try {
            parser.parse(is);
        }
        catch (MimeException ex) {
            throw new MimeIOException(ex);
        }
        return header;
    }

    @Override
    public Message newMessage() {
        return new MessageImpl();
    }

    @Override
    public Message newMessage(Message source) {
        return this.copy(source);
    }

    @Override
    public Message parseMessage(InputStream is) throws IOException, MimeIOException {
        try {
            DecodeMonitor mon;
            MessageImpl message = new MessageImpl();
            MimeConfig cfg = this.config != null ? this.config : new MimeConfig();
            boolean strict = cfg.isStrictParsing();
            DecodeMonitor decodeMonitor = this.monitor != null ? this.monitor : (mon = strict ? DecodeMonitor.STRICT : DecodeMonitor.SILENT);
            BodyDescriptorBuilder bdb = this.bodyDescBuilder != null ? this.bodyDescBuilder : new DefaultBodyDescriptorBuilder(null, this.fieldParser != null ? this.fieldParser : (strict ? DefaultFieldParser.getParser() : LenientFieldParser.getParser()), mon);
            BodyFactory bf = this.bodyFactory != null ? this.bodyFactory : new BasicBodyFactory();
            MimeStreamParser parser = new MimeStreamParser(cfg, mon, bdb);
            parser.setContentHandler((ContentHandler)new EntityBuilder(message, bf));
            parser.setContentDecoding(this.contentDecoding);
            if (this.flatMode) {
                parser.setFlat();
            } else {
                parser.setRecurse();
            }
            parser.parse(is);
            return message;
        }
        catch (MimeException e) {
            throw new MimeIOException(e);
        }
    }
}

