/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.stream.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeFieldLenientImpl
extends AbstractField
implements DateTimeField {
    private static final String DEFAULT_DATE_FORMAT = "EEE, dd MMM yyyy hh:mm:ss ZZZZ";
    private final List<String> datePatterns = new ArrayList<String>();
    private boolean parsed = false;
    private Date date;
    public static final FieldParser<DateTimeField> PARSER = new FieldParser<DateTimeField>(){

        @Override
        public DateTimeField parse(Field rawField, DecodeMonitor monitor) {
            return new DateTimeFieldLenientImpl(rawField, null, monitor);
        }
    };

    DateTimeFieldLenientImpl(Field rawField, Collection<String> dateParsers, DecodeMonitor monitor) {
        super(rawField, monitor);
        if (dateParsers != null) {
            this.datePatterns.addAll(dateParsers);
        } else {
            this.datePatterns.add(DEFAULT_DATE_FORMAT);
        }
    }

    @Override
    public Date getDate() {
        if (!this.parsed) {
            this.parse();
        }
        return this.date;
    }

    private void parse() {
        this.parsed = true;
        this.date = null;
        String body = this.getBody();
        for (String datePattern : this.datePatterns) {
            try {
                SimpleDateFormat parser = new SimpleDateFormat(datePattern, Locale.US);
                parser.setTimeZone(TimeZone.getTimeZone("GMT"));
                parser.setLenient(true);
                this.date = parser.parse(body);
                break;
            }
            catch (ParseException ignore) {
            }
        }
    }
}

