/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import javax.persistence.TemporalType;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.IterationCallback;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.Select;
import org.seasar.extension.jdbc.StatementHandler;
import org.seasar.extension.jdbc.exception.SNoResultException;
import org.seasar.extension.jdbc.exception.SNonUniqueResultException;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractQuery;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelect<T, S extends Select<T, S>>
extends AbstractQuery<S>
implements Select<T, S> {
    protected Class<T> baseClass;
    protected int maxRows;
    protected int fetchSize;
    protected int offset;
    protected int limit;
    protected boolean disallowNoResult;
    protected boolean resultLob;
    protected TemporalType resultTemporalType;
    protected boolean count;

    public AbstractSelect(JdbcManagerImplementor jdbcManager, Class<T> baseClass) {
        super(jdbcManager);
        this.baseClass = baseClass;
    }

    @Override
    public S maxRows(int maxRows) {
        this.maxRows = maxRows;
        return (S)this;
    }

    @Override
    public S fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return (S)this;
    }

    @Override
    public S limit(int limit) {
        this.limit = limit;
        return (S)this;
    }

    @Override
    public S offset(int offset) {
        this.offset = offset;
        return (S)this;
    }

    @Override
    public S disallowNoResult() {
        this.disallowNoResult = true;
        return (S)this;
    }

    @Override
    public S lob() {
        this.resultLob = true;
        return (S)this;
    }

    @Override
    public S temporal(TemporalType temporalType) {
        this.resultTemporalType = temporalType;
        return (S)this;
    }

    protected String convertLimitSql(String sql) {
        DbmsDialect dialect = this.jdbcManager.getDialect();
        if (dialect.supportsLimit() && (this.limit > 0 || this.limit == 0 && this.offset > 0 && dialect.supportsOffsetWithoutLimit())) {
            return dialect.convertLimitSql(sql, this.offset, this.limit);
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getResultList() {
        this.prepare("getResultList");
        this.logSql();
        try {
            List<T> list = this.getResultListInternal();
            return list;
        }
        finally {
            this.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getSingleResult() throws SNonUniqueResultException {
        this.prepare("getSingleResult");
        this.logSql();
        try {
            T t = this.getSingleResultInternal();
            return t;
        }
        finally {
            this.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RESULT> RESULT iterate(IterationCallback<T, RESULT> callback) {
        this.prepare("iterate");
        this.logSql();
        try {
            RESULT RESULT = this.iterateInternal(callback);
            return RESULT;
        }
        finally {
            this.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount() {
        this.count = true;
        this.prepare("getCount");
        this.logSql();
        try {
            long l = (Long)Long.class.cast(this.getSingleResultInternal());
            return l;
        }
        finally {
            this.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> getResultListInternal() {
        ResultSetHandler handler = this.createResultListResultSetHandler();
        List ret = null;
        JdbcContext jdbcContext = this.jdbcManager.getJdbcContext();
        try {
            ret = (List)this.processResultSet(jdbcContext, handler);
            if (this.disallowNoResult && ret.isEmpty()) {
                throw new SNoResultException(this.executedSql);
            }
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T getSingleResultInternal() {
        ResultSetHandler handler = this.createSingleResultResultSetHandler();
        Object ret = null;
        JdbcContext jdbcContext = this.jdbcManager.getJdbcContext();
        try {
            ret = this.processResultSet(jdbcContext, handler);
            if (this.disallowNoResult && ret == null) {
                throw new SNoResultException(this.executedSql);
            }
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
        return (T)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RESULT> RESULT iterateInternal(IterationCallback<T, RESULT> callback) {
        ResultSetHandler handler = this.createIterateResultSetHandler(callback);
        JdbcContext jdbcContext = this.jdbcManager.getJdbcContext();
        try {
            Object object = this.processResultSet(jdbcContext, handler);
            return (RESULT)object;
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
    }

    protected Object processPreparedStatement(JdbcContext jdbcContext, final StatementHandler<Object, PreparedStatement> handler) {
        return jdbcContext.usingPreparedStatement(this.executedSql, new StatementHandler<Object, PreparedStatement>(){

            @Override
            public Object handle(PreparedStatement ps) {
                AbstractSelect.this.setupPreparedStatement(ps);
                return handler.handle(ps);
            }
        });
    }

    protected Object processCursorPreparedStatement(JdbcContext jdbcContext, final StatementHandler<Object, PreparedStatement> handler) {
        return jdbcContext.usingCursorPreparedStatement(this.executedSql, new StatementHandler<Object, PreparedStatement>(){

            @Override
            public Object handle(PreparedStatement ps) {
                AbstractSelect.this.setupPreparedStatement(ps);
                return handler.handle(ps);
            }
        });
    }

    protected void setupPreparedStatement(PreparedStatement ps) {
        if (this.maxRows > 0) {
            StatementUtil.setMaxRows((Statement)ps, (int)this.maxRows);
        }
        if (this.fetchSize > 0) {
            StatementUtil.setFetchSize((Statement)ps, (int)this.fetchSize);
        }
        if (this.queryTimeout > 0) {
            StatementUtil.setQueryTimeout((Statement)ps, (int)this.queryTimeout);
        }
        this.prepareInParams(ps);
    }

    protected abstract ResultSetHandler createResultListResultSetHandler();

    protected abstract ResultSetHandler createSingleResultResultSetHandler();

    protected abstract ResultSetHandler createIterateResultSetHandler(IterationCallback<T, ?> var1);

    protected Object processResultSet(JdbcContext jdbcContext, final ResultSetHandler handler) {
        DbmsDialect dialect = this.jdbcManager.getDialect();
        if (this.offset > 0) {
            if (dialect.supportsOffset() && (this.limit > 0 || this.limit == 0 && dialect.supportsOffsetWithoutLimit())) {
                return this.processPreparedStatement(jdbcContext, new StatementHandler<Object, PreparedStatement>(){

                    @Override
                    public Object handle(PreparedStatement ps) {
                        ResultSet rs = PreparedStatementUtil.executeQuery((PreparedStatement)ps);
                        return AbstractSelect.this.handleResultSet(handler, rs);
                    }
                });
            }
            if (dialect.supportsCursor()) {
                return this.processCursorPreparedStatement(jdbcContext, new StatementHandler<Object, PreparedStatement>(){

                    @Override
                    public Object handle(PreparedStatement ps) {
                        ResultSet rs = PreparedStatementUtil.executeQuery((PreparedStatement)ps);
                        ResultSetUtil.absolute((ResultSet)rs, (int)AbstractSelect.this.offset);
                        return AbstractSelect.this.handleResultSet(handler, rs);
                    }
                });
            }
            return this.processPreparedStatement(jdbcContext, new StatementHandler<Object, PreparedStatement>(){

                @Override
                public Object handle(PreparedStatement ps) {
                    ResultSet rs = PreparedStatementUtil.executeQuery((PreparedStatement)ps);
                    for (int i = 0; i < AbstractSelect.this.offset && ResultSetUtil.next((ResultSet)rs); ++i) {
                    }
                    return AbstractSelect.this.handleResultSet(handler, rs);
                }
            });
        }
        return this.processPreparedStatement(jdbcContext, new StatementHandler<Object, PreparedStatement>(){

            @Override
            public Object handle(PreparedStatement ps) {
                ResultSet rs = PreparedStatementUtil.executeQuery((PreparedStatement)ps);
                return AbstractSelect.this.handleResultSet(handler, rs);
            }
        });
    }

    public Class<T> getBaseClass() {
        return this.baseClass;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getOffset() {
        return this.offset;
    }
}

