/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.id;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.IdGenerator;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.exception.IdGenerationFailedRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.NumberConversionUtil;
import org.seasar.framework.util.ResultSetUtil;

public abstract class AbstractIdGenerator
implements IdGenerator {
    protected EntityMeta entityMeta;
    protected PropertyMeta propertyMeta;

    public AbstractIdGenerator(EntityMeta entityMeta, PropertyMeta propertyMeta) {
        this.entityMeta = entityMeta;
        this.propertyMeta = propertyMeta;
    }

    protected void setId(Object entity, long id) {
        Field field = this.propertyMeta.getField();
        Class fieldType = ClassUtil.getWrapperClassIfPrimitive(field.getType());
        Object value = NumberConversionUtil.convertNumber((Class)fieldType, (Object)id);
        FieldUtil.set((Field)field, (Object)entity, (Object)value);
    }

    protected long getGeneratedId(ResultSet rs) {
        try {
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            try {
                throw new IdGenerationFailedRuntimeException(this.entityMeta.getName(), this.propertyMeta.getName());
            }
            catch (SQLException e) {
                throw new IdGenerationFailedRuntimeException(this.entityMeta.getName(), this.propertyMeta.getName(), e);
            }
        }
        finally {
            ResultSetUtil.close((ResultSet)rs);
        }
    }
}

