/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.MappingCharFilter;
import org.apache.lucene.analysis.NormalizeCharMap;
import org.apache.solr.analysis.BaseCharFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingCharFilterFactory
extends BaseCharFilterFactory
implements ResourceLoaderAware {
    protected NormalizeCharMap normMap;
    private String mapping;
    static Pattern p = Pattern.compile("\"(.*)\"\\s*=>\\s*\"(.*)\"\\s*$");
    char[] out = new char[256];

    @Override
    public void inform(ResourceLoader loader) {
        this.mapping = (String)this.args.get("mapping");
        if (this.mapping != null) {
            ArrayList<String> wlist = null;
            try {
                File mappingFile = new File(this.mapping);
                if (mappingFile.exists()) {
                    wlist = loader.getLines(this.mapping);
                } else {
                    List files = StrUtils.splitFileNames((String)this.mapping);
                    wlist = new ArrayList<String>();
                    for (String file : files) {
                        List lines = loader.getLines(file.trim());
                        wlist.addAll(lines);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.normMap = new NormalizeCharMap();
            this.parseRules(wlist, this.normMap);
        }
    }

    @Override
    public CharStream create(CharStream input) {
        return new MappingCharFilter(this.normMap, input);
    }

    protected void parseRules(List<String> rules, NormalizeCharMap normMap) {
        for (String rule : rules) {
            Matcher m = p.matcher(rule);
            if (!m.find()) {
                throw new RuntimeException("Invalid Mapping Rule : [" + rule + "], file = " + this.mapping);
            }
            normMap.add(this.parseString(m.group(1)), this.parseString(m.group(2)));
        }
    }

    protected String parseString(String s) {
        int readPos = 0;
        int len = s.length();
        int writePos = 0;
        while (readPos < len) {
            int c;
            if ((c = s.charAt(readPos++)) == 92) {
                if (readPos >= len) {
                    throw new RuntimeException("Invalid escaped char in [" + s + "]");
                }
                c = s.charAt(readPos++);
                switch (c) {
                    case 92: {
                        c = 92;
                        break;
                    }
                    case 34: {
                        c = 34;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 117: {
                        if (readPos + 3 >= len) {
                            throw new RuntimeException("Invalid escaped char in [" + s + "]");
                        }
                        c = (char)Integer.parseInt(s.substring(readPos, readPos + 4), 16);
                        readPos += 4;
                    }
                }
            }
            this.out[writePos++] = c;
        }
        return new String(this.out, 0, writePos);
    }
}

