/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.container.external.AbstractExternalContextMap;
import org.seasar.framework.container.hotdeploy.HotdeployClassLoader;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;

public abstract class RebuildableExternalContextMap
extends AbstractExternalContextMap {
    protected static WeakReference hotdeployClassLoader = new WeakReference<Object>(null);
    protected static Set rebuiltNames = new HashSet(64);

    public Object get(Object key) {
        Object value = this.getAttribute(key.toString());
        if (value == null || !this.isHotdeployMode()) {
            return value;
        }
        if (rebuiltNames.contains(key)) {
            return value;
        }
        Object rebuiltValue = HotdeployUtil.rebuildValue(value);
        rebuiltNames.add(key);
        this.setAttribute(key.toString(), rebuiltValue);
        return rebuiltValue;
    }

    public Object put(Object key, Object value) {
        Object oldValue = super.put(key, value);
        if (this.isHotdeployMode()) {
            rebuiltNames.add(key);
        }
        return oldValue;
    }

    public void putAll(Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected boolean isHotdeployMode() {
        if (!HotdeployUtil.isHotdeploy()) {
            return false;
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (!(currentLoader instanceof HotdeployClassLoader)) {
            return false;
        }
        if (currentLoader != hotdeployClassLoader.get()) {
            hotdeployClassLoader = new WeakReference<ClassLoader>(currentLoader);
            rebuiltNames.clear();
        }
        return true;
    }
}

