/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.MethodUtil;

public class DelegateInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 3613140488663554089L;
    private Object target;
    private BeanDesc beanDesc;
    private Map methodNameMap = new HashMap();

    public DelegateInterceptor() {
    }

    public DelegateInterceptor(Object target) {
        this.setTarget(target);
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
        this.beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
    }

    public void addMethodNameMap(String methodName, String targetMethodName) {
        this.methodNameMap.put(methodName, targetMethodName);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.target == null) {
            throw new EmptyRuntimeException("target");
        }
        Method method = invocation.getMethod();
        String methodName = method.getName();
        if (this.methodNameMap.containsKey(methodName)) {
            methodName = (String)this.methodNameMap.get(methodName);
        }
        if (!MethodUtil.isAbstract(method)) {
            return invocation.proceed();
        }
        if (this.beanDesc.hasMethod(methodName)) {
            return this.beanDesc.invoke(this.target, methodName, invocation.getArguments());
        }
        throw new MethodNotFoundRuntimeException(this.getTargetClass(invocation), methodName, invocation.getArguments());
    }
}

