/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.tx;

import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.extension.tx.TransactionCallback;
import org.seasar.extension.tx.TransactionManagerAdapter;
import org.seasar.extension.tx.TxRule;

public class DefaultTransactionCallback
implements TransactionCallback {
    protected final MethodInvocation methodInvocation;
    protected final List txRules;

    public DefaultTransactionCallback(MethodInvocation methodInvocation, List txRules) {
        this.methodInvocation = methodInvocation;
        this.txRules = txRules;
    }

    public Object execute(TransactionManagerAdapter adapter) throws Throwable {
        try {
            return this.methodInvocation.proceed();
        }
        catch (Throwable t) {
            this.applyTxRule(adapter, t);
            throw t;
        }
    }

    protected void applyTxRule(TransactionManagerAdapter adapter, Throwable t) {
        for (int i = 0; i < this.txRules.size(); ++i) {
            TxRule rule = (TxRule)this.txRules.get(i);
            if (!rule.isAssignableFrom(t)) continue;
            rule.complete(adapter);
            return;
        }
        adapter.setRollbackOnly();
    }
}

