/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.seasar.dbflute.cbean.MapParameterBean;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.exception.BindVariableCommentNotFoundPropertyException;
import org.seasar.dbflute.exception.EmbeddedValueCommentNotFoundPropertyException;
import org.seasar.dbflute.exception.RequiredOptionNotFoundException;
import org.seasar.dbflute.s2dao.beans.TnBeanDesc;
import org.seasar.dbflute.s2dao.beans.TnPropertyDesc;
import org.seasar.dbflute.s2dao.beans.factory.TnBeanDescFactory;
import org.seasar.dbflute.twowaysql.node.ValueAndType;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueAndTypeSetupper {
    protected String _expression;
    protected String[] _names;
    protected String _specifiedSql;
    protected boolean _bind;

    public ValueAndTypeSetupper(String expression, String[] names, String specifiedSql, boolean bind) {
        this._expression = expression;
        this._names = names;
        this._specifiedSql = specifiedSql;
        this._bind = bind;
    }

    public void setupValueAndType(ValueAndType valueAndType) {
        Object value = valueAndType.getTargetValue();
        Class<?> clazz = valueAndType.getTargetType();
        LikeSearchOption likeSearchOption = null;
        String rearOption = null;
        for (int pos = 1; pos < this._names.length && value != null; ++pos) {
            TnBeanDesc beanDesc;
            String currentName = this._names[pos];
            if (pos == 1 && this.hasLikeSearchOption(beanDesc = TnBeanDescFactory.getBeanDesc(clazz), currentName)) {
                likeSearchOption = this.getLikeSearchOption(beanDesc, currentName, value);
            }
            if (Map.class.isInstance(value)) {
                Map map = (Map)value;
                value = map.get(this._names[pos]);
                if (this.isLastLoop4LikeSearch(pos, likeSearchOption) && this.isValidStringValue(value)) {
                    value = likeSearchOption.generateRealValue((String)value);
                    rearOption = likeSearchOption.getRearOption();
                }
                clazz = value != null ? value.getClass() : clazz;
                continue;
            }
            beanDesc = TnBeanDescFactory.getBeanDesc(clazz);
            if (beanDesc.hasPropertyDesc(currentName)) {
                TnPropertyDesc pd = beanDesc.getPropertyDesc(currentName);
                value = this.getPropertyValue(clazz, value, currentName, pd);
                if (this.isLastLoop4LikeSearch(pos, likeSearchOption) && this.isValidStringValue(value)) {
                    value = likeSearchOption.generateRealValue((String)value);
                    rearOption = likeSearchOption.getRearOption();
                }
                clazz = value != null ? value.getClass() : pd.getPropertyType();
                continue;
            }
            String methodName = "get" + this.initCap(currentName);
            if (beanDesc.hasMethod(methodName)) {
                Method method = beanDesc.getMethod(methodName);
                value = this.invokeGetter(method, value);
                clazz = method.getReturnType();
                continue;
            }
            if (pos == 1 && MapParameterBean.class.isAssignableFrom(clazz)) {
                Object elementValue;
                MapParameterBean pmb = (MapParameterBean)value;
                Map<String, Object> map = pmb.getParameterMap();
                Object object = elementValue = map != null ? map.get(this._names[pos]) : null;
                if (elementValue != null) {
                    value = elementValue;
                    clazz = value.getClass();
                    continue;
                }
            }
            this.throwBindOrEmbeddedCommentNotFoundPropertyException(this._expression, clazz, currentName, this._specifiedSql, this._bind);
        }
        valueAndType.setTargetValue(value);
        valueAndType.setTargetType(clazz);
        valueAndType.setRearOption(rearOption);
    }

    protected boolean isLastLoop4LikeSearch(int pos, LikeSearchOption likeSearchOption) {
        return this._names.length == pos + 1 && likeSearchOption != null;
    }

    protected boolean isValidStringValue(Object value) {
        return value != null && value instanceof String && ((String)value).length() > 0;
    }

    protected boolean hasLikeSearchOption(TnBeanDesc beanDesc, String currentName) {
        return beanDesc.hasPropertyDesc(currentName + "InternalLikeSearchOption");
    }

    protected LikeSearchOption getLikeSearchOption(TnBeanDesc beanDesc, String currentName, Object resourceBean) {
        TnPropertyDesc pb = beanDesc.getPropertyDesc(currentName + "InternalLikeSearchOption");
        LikeSearchOption option = (LikeSearchOption)pb.getValue(resourceBean);
        if (option == null) {
            this.throwLikeSearchOptionNotFoundException(resourceBean, currentName);
        }
        if (option.isSplit()) {
            this.throwOutsideSqlLikeSearchOptionSplitUnsupportedException(option, resourceBean, currentName);
        }
        return option;
    }

    protected void throwLikeSearchOptionNotFoundException(Object resourceBean, String currentName) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The likeSearchOption was Not Found! (Should not be null!)" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your method call:" + this.ln();
        String beanName = resourceBean.getClass().getSimpleName();
        String methodName = "set" + this.initCap(currentName) + "_LikeSearch(value, likeSearchOption);";
        msg = msg + "    " + beanName + "." + methodName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Target ParameterBean]" + this.ln() + resourceBean + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new RequiredOptionNotFoundException(msg);
    }

    protected void throwOutsideSqlLikeSearchOptionSplitUnsupportedException(LikeSearchOption option, Object resourceBean, String currentName) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The splitByXxx() of LikeSearchOption is unsupported at OutsideSql!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your method call:" + this.ln();
        msg = msg + "  For example:" + this.ln();
        msg = msg + "    before (x):" + this.ln();
        String beanName = resourceBean.getClass().getSimpleName();
        String methodName = "set" + this.initCap(currentName) + "_LikeSearch(value, likeSearchOption);";
        msg = msg + "      " + beanName + " pmb = new " + beanName + "();" + this.ln();
        msg = msg + "      LikeSearchOption likeSearchOption = new LikeSearchOption().likeContain();" + this.ln();
        msg = msg + "      likeSearchOption.splitBySpace(); // *No! Don't invoke this!" + this.ln();
        msg = msg + "      pmb." + methodName + this.ln();
        msg = msg + "    after  (o):" + this.ln();
        msg = msg + "      " + beanName + " pmb = new " + beanName + "();" + this.ln();
        msg = msg + "      LikeSearchOption likeSearchOption = new LikeSearchOption().likeContain();" + this.ln();
        msg = msg + "      pmb." + methodName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Target LikeSearchOption]" + this.ln() + option + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Target ParameterBean]" + this.ln() + resourceBean + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new UnsupportedOperationException(msg);
    }

    protected Object getPropertyValue(Class<?> beanType, Object beanValue, String currentName, TnPropertyDesc pd) {
        try {
            return pd.getValue(beanValue);
        }
        catch (RuntimeException e) {
            this.throwPropertyHandlingFailureException(beanType, beanValue, currentName, this._expression, this._specifiedSql, this._bind, e);
            return null;
        }
    }

    protected void throwPropertyHandlingFailureException(Class<?> beanType, Object beanValue, String currentName, String expression, String specifiedSql, boolean bind, Exception e) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The handlig of the property was failed!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "This is the Framework Exception!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[" + (bind ? "Bind Variable" : "Embedded Value") + " Comment Expression]" + this.ln() + expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Bean Type]" + this.ln() + beanType + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Bean Value]" + this.ln() + beanValue + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Property Name]" + this.ln() + currentName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IllegalStateException(msg, e);
    }

    protected Object invokeGetter(Method method, Object target) {
        try {
            return method.invoke(target, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected void throwBindOrEmbeddedCommentNotFoundPropertyException(String expression, Class<?> targetType, String notFoundProperty, String specifiedSql, boolean bind) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The property on the " + (bind ? "bind variable" : "embedded value") + " comment was Not Found!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm the existence of your property on your arguments." + this.ln();
        msg = msg + "Abd has the property had misspelling?" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[" + (bind ? "Bind Variable" : "Embedded Value") + " Comment Expression]" + this.ln() + expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[NotFound Property]" + this.ln() + (targetType != null ? targetType.getName() + "#" : "") + notFoundProperty + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        if (bind) {
            throw new BindVariableCommentNotFoundPropertyException(msg);
        }
        throw new EmbeddedValueCommentNotFoundPropertyException(msg);
    }

    protected String initCap(String name) {
        return DfStringUtil.initCap(name);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

