/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.solr.common.params.DefaultSolrParams;
import org.apache.solr.common.params.HighlightParams;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocList;
import org.apache.solr.util.SolrHighlighterX;

public class HighlightingUtils
implements HighlightParams {
    static SolrParams DEFAULTS = null;
    private static SolrHighlighterX HIGHLIGHTER;

    static SolrParams getParams(SolrQueryRequest request) {
        return new DefaultSolrParams(request.getParams(), DEFAULTS);
    }

    public static boolean isHighlightingEnabled(SolrQueryRequest request) {
        return HIGHLIGHTER.isHighlightingEnabled(HighlightingUtils.getParams(request));
    }

    public static Highlighter getHighlighter(Query query, String fieldName, SolrQueryRequest request) {
        return HIGHLIGHTER.getHighlighterX(query, fieldName, request);
    }

    public static String[] getHighlightFields(Query query, SolrQueryRequest request, String[] defaultFields) {
        return HIGHLIGHTER.getHighlightFields(query, request, defaultFields);
    }

    public static int getMaxSnippets(String fieldName, SolrQueryRequest request) {
        return HIGHLIGHTER.getMaxSnippetsX(fieldName, request);
    }

    public static Formatter getFormatter(String fieldName, SolrQueryRequest request) {
        return HIGHLIGHTER.getFormatterX(fieldName, request);
    }

    public static Fragmenter getFragmenter(String fieldName, SolrQueryRequest request) {
        return HIGHLIGHTER.getFragmenterX(fieldName, request);
    }

    public static NamedList doHighlighting(DocList docs, Query query, SolrQueryRequest req, String[] defaultFields) throws IOException {
        return HIGHLIGHTER.doHighlighting(docs, query, req, defaultFields);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hl.snippets", "1");
        map.put("hl.fragsize", "100");
        map.put("hl.formatter", "simple");
        map.put("hl.simple.pre", "<em>");
        map.put("hl.simple.post", "</em>");
        DEFAULTS = new MapSolrParams(map);
        HIGHLIGHTER = new SolrHighlighterX();
    }
}

