/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.BufferedDeletes;
import org.apache.lucene.index.ByteBlockPool;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocConsumer;
import org.apache.lucene.index.DocConsumerPerThread;
import org.apache.lucene.index.DocFieldProcessor;
import org.apache.lucene.index.DocInverter;
import org.apache.lucene.index.DocumentsWriterThreadState;
import org.apache.lucene.index.FreqProxTermsWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeDocIDRemapper;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NormsWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermVectorsTermsWriter;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Constants;

final class DocumentsWriter {
    IndexWriter writer;
    Directory directory;
    String segment;
    private String docStoreSegment;
    private int docStoreOffset;
    private int nextDocID;
    private int numDocsInRAM;
    int numDocsInStore;
    private static final int MAX_THREAD_STATE = 5;
    private DocumentsWriterThreadState[] threadStates = new DocumentsWriterThreadState[0];
    private final HashMap threadBindings = new HashMap();
    private int pauseThreads;
    boolean flushPending;
    boolean bufferIsFull;
    private boolean aborting;
    private DocFieldProcessor docFieldProcessor;
    PrintStream infoStream;
    int maxFieldLength = 10000;
    Similarity similarity;
    List newFiles;
    static final IndexingChain DefaultIndexingChain;
    final DocConsumer consumer;
    private BufferedDeletes deletesInRAM = new BufferedDeletes(false);
    private BufferedDeletes deletesFlushed = new BufferedDeletes(true);
    private int maxBufferedDeleteTerms = -1;
    private long ramBufferSize = 0x1000000L;
    private long waitQueuePauseBytes = (long)((double)this.ramBufferSize * 0.1);
    private long waitQueueResumeBytes = (long)((double)this.ramBufferSize * 0.05);
    private long freeTrigger = 0x10CCCCCL;
    private long freeLevel = 0xF33333L;
    private int maxBufferedDocs = -1;
    private int flushedDocCount;
    private boolean closed;
    private Collection abortedFiles;
    private SegmentWriteState flushState;
    final List openFiles = new ArrayList();
    final List closedFiles = new ArrayList();
    private Term lastDeleteTerm;
    final SkipDocWriter skipDocWriter = new SkipDocWriter();
    long numBytesAlloc;
    long numBytesUsed;
    NumberFormat nf = NumberFormat.getInstance();
    static final int OBJECT_HEADER_BYTES = 8;
    static final int POINTER_NUM_BYTE;
    static final int INT_NUM_BYTE = 4;
    static final int CHAR_NUM_BYTE = 2;
    static final int BYTES_PER_DEL_TERM;
    static final int BYTES_PER_DEL_DOCID;
    static final int BYTES_PER_DEL_QUERY;
    static final int BYTE_BLOCK_SHIFT = 15;
    static final int BYTE_BLOCK_SIZE = 32768;
    static final int BYTE_BLOCK_MASK = Short.MAX_VALUE;
    static final int BYTE_BLOCK_NOT_MASK = Short.MIN_VALUE;
    static final int INT_BLOCK_SHIFT = 13;
    static final int INT_BLOCK_SIZE = 8192;
    static final int INT_BLOCK_MASK = 8191;
    private ArrayList freeIntBlocks = new ArrayList();
    ByteBlockAllocator byteBlockAllocator = new ByteBlockAllocator(32768);
    static final int PER_DOC_BLOCK_SIZE = 1024;
    final ByteBlockAllocator perDocAllocator = new ByteBlockAllocator(1024);
    static final int CHAR_BLOCK_SHIFT = 14;
    static final int CHAR_BLOCK_SIZE = 16384;
    static final int CHAR_BLOCK_MASK = 16383;
    static final int MAX_TERM_LENGTH = 16383;
    private ArrayList freeCharBlocks = new ArrayList();
    final WaitQueue waitQueue = new WaitQueue();
    static final /* synthetic */ boolean $assertionsDisabled;

    PerDocBuffer newPerDocBuffer() {
        return new PerDocBuffer();
    }

    synchronized void updateFlushedDocCount(int n) {
        this.flushedDocCount += n;
    }

    synchronized int getFlushedDocCount() {
        return this.flushedDocCount;
    }

    synchronized void setFlushedDocCount(int n) {
        this.flushedDocCount = n;
    }

    DocumentsWriter(Directory directory, IndexWriter writer, IndexingChain indexingChain) throws IOException {
        this.directory = directory;
        this.writer = writer;
        this.similarity = writer.getSimilarity();
        this.flushedDocCount = writer.maxDoc();
        this.consumer = indexingChain.getChain(this);
        if (this.consumer instanceof DocFieldProcessor) {
            this.docFieldProcessor = (DocFieldProcessor)this.consumer;
        }
    }

    boolean hasProx() {
        return this.docFieldProcessor != null ? this.docFieldProcessor.fieldInfos.hasProx() : true;
    }

    synchronized void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].docState.infoStream = infoStream;
        }
    }

    synchronized void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].docState.maxFieldLength = maxFieldLength;
        }
    }

    synchronized void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].docState.similarity = similarity;
        }
    }

    synchronized void setAllowMinus1Position() {
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].docState.allowMinus1Position = true;
        }
    }

    synchronized void setRAMBufferSizeMB(double mb) {
        if (mb == -1.0) {
            this.ramBufferSize = -1L;
            this.waitQueuePauseBytes = 0x400000L;
            this.waitQueueResumeBytes = 0x200000L;
        } else {
            this.ramBufferSize = (long)(mb * 1024.0 * 1024.0);
            this.waitQueuePauseBytes = (long)((double)this.ramBufferSize * 0.1);
            this.waitQueueResumeBytes = (long)((double)this.ramBufferSize * 0.05);
            this.freeTrigger = (long)(1.05 * (double)this.ramBufferSize);
            this.freeLevel = (long)(0.95 * (double)this.ramBufferSize);
        }
    }

    synchronized double getRAMBufferSizeMB() {
        if (this.ramBufferSize == -1L) {
            return this.ramBufferSize;
        }
        return (double)this.ramBufferSize / 1024.0 / 1024.0;
    }

    void setMaxBufferedDocs(int count) {
        this.maxBufferedDocs = count;
    }

    int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    String getSegment() {
        return this.segment;
    }

    int getNumDocsInRAM() {
        return this.numDocsInRAM;
    }

    synchronized String getDocStoreSegment() {
        return this.docStoreSegment;
    }

    int getDocStoreOffset() {
        return this.docStoreOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String closeDocStore() throws IOException {
        if (!$assertionsDisabled && !this.allThreadsIdle()) {
            throw new AssertionError();
        }
        if (this.infoStream != null) {
            this.message("closeDocStore: " + this.openFiles.size() + " files to flush to segment " + this.docStoreSegment + " numDocs=" + this.numDocsInStore);
        }
        boolean success = false;
        try {
            this.initFlushState(true);
            this.closedFiles.clear();
            this.consumer.closeDocStore(this.flushState);
            if (!$assertionsDisabled && 0 != this.openFiles.size()) {
                throw new AssertionError();
            }
            String s = this.docStoreSegment;
            this.docStoreSegment = null;
            this.docStoreOffset = 0;
            this.numDocsInStore = 0;
            success = true;
            String string = s;
            return string;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    Collection abortedFiles() {
        return this.abortedFiles;
    }

    void message(String message) {
        if (this.infoStream != null) {
            this.writer.message("DW: " + message);
        }
    }

    synchronized List openFiles() {
        return (List)((ArrayList)this.openFiles).clone();
    }

    synchronized List closedFiles() {
        return (List)((ArrayList)this.closedFiles).clone();
    }

    synchronized void addOpenFile(String name) {
        if (!$assertionsDisabled && this.openFiles.contains(name)) {
            throw new AssertionError();
        }
        this.openFiles.add(name);
    }

    synchronized void removeOpenFile(String name) {
        if (!$assertionsDisabled && !this.openFiles.contains(name)) {
            throw new AssertionError();
        }
        this.openFiles.remove(name);
        this.closedFiles.add(name);
    }

    synchronized void setAborting() {
        this.aborting = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void abort() throws IOException {
        try {
            if (this.infoStream != null) {
                this.message("docWriter: now abort");
            }
            this.waitQueue.abort();
            this.pauseAllThreads();
            try {
                if (!$assertionsDisabled && 0 != this.waitQueue.numWaiting) {
                    throw new AssertionError();
                }
                this.waitQueue.waitingBytes = 0L;
                try {
                    this.abortedFiles = this.openFiles();
                }
                catch (Throwable t) {
                    this.abortedFiles = null;
                }
                this.deletesInRAM.clear();
                this.openFiles.clear();
                for (int i = 0; i < this.threadStates.length; ++i) {
                    try {
                        this.threadStates[i].consumer.abort();
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    this.consumer.abort();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.docStoreSegment = null;
                this.numDocsInStore = 0;
                this.docStoreOffset = 0;
                this.doAfterFlush();
            }
            finally {
                this.resumeAllThreads();
            }
        }
        finally {
            this.aborting = false;
            this.notifyAll();
        }
    }

    private void doAfterFlush() throws IOException {
        if (!$assertionsDisabled && !this.allThreadsIdle()) {
            throw new AssertionError();
        }
        this.threadBindings.clear();
        this.waitQueue.reset();
        this.segment = null;
        this.numDocsInRAM = 0;
        this.nextDocID = 0;
        this.bufferIsFull = false;
        this.flushPending = false;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].doAfterFlush();
        }
        this.numBytesUsed = 0L;
    }

    synchronized boolean pauseAllThreads() {
        ++this.pauseThreads;
        while (!this.allThreadsIdle()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
        }
        return this.aborting;
    }

    synchronized void resumeAllThreads() {
        --this.pauseThreads;
        if (!$assertionsDisabled && this.pauseThreads < 0) {
            throw new AssertionError();
        }
        if (0 == this.pauseThreads) {
            this.notifyAll();
        }
    }

    private synchronized boolean allThreadsIdle() {
        for (int i = 0; i < this.threadStates.length; ++i) {
            if (this.threadStates[i].isIdle) continue;
            return false;
        }
        return true;
    }

    synchronized boolean anyChanges() {
        return this.numDocsInRAM != 0 || this.deletesInRAM.numTerms != 0 || this.deletesInRAM.docIDs.size() != 0 || this.deletesInRAM.queries.size() != 0;
    }

    private synchronized void initFlushState(boolean onlyDocStore) {
        this.initSegmentName(onlyDocStore);
        this.flushState = new SegmentWriteState(this, this.directory, this.segment, this.docStoreSegment, this.numDocsInRAM, this.numDocsInStore, this.writer.getTermIndexInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int flush(boolean closeDocStore) throws IOException {
        if (!$assertionsDisabled && !this.allThreadsIdle()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.numDocsInRAM <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.nextDocID != this.numDocsInRAM) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.waitQueue.numWaiting != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.waitQueue.waitingBytes != 0L) {
            throw new AssertionError();
        }
        this.initFlushState(false);
        this.docStoreOffset = this.numDocsInStore;
        if (this.infoStream != null) {
            this.message("flush postings as segment " + this.flushState.segmentName + " numDocs=" + this.numDocsInRAM);
        }
        boolean success = false;
        try {
            if (closeDocStore) {
                if (!$assertionsDisabled && this.flushState.docStoreSegmentName == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !this.flushState.docStoreSegmentName.equals(this.flushState.segmentName)) {
                    throw new AssertionError();
                }
                this.closeDocStore();
                this.flushState.numDocsInStore = 0;
            }
            HashSet<DocConsumerPerThread> threads = new HashSet<DocConsumerPerThread>();
            for (int i = 0; i < this.threadStates.length; ++i) {
                threads.add(this.threadStates[i].consumer);
            }
            this.consumer.flush(threads, this.flushState);
            if (this.infoStream != null) {
                SegmentInfo si = new SegmentInfo(this.flushState.segmentName, this.flushState.numDocs, this.directory);
                long newSegmentSize = si.sizeInBytes();
                String message = "  oldRAMSize=" + this.numBytesUsed + " newFlushedSize=" + newSegmentSize + " docs/MB=" + this.nf.format((double)this.numDocsInRAM / ((double)newSegmentSize / 1024.0 / 1024.0)) + " new/old=" + this.nf.format(100.0 * (double)newSegmentSize / (double)this.numBytesUsed) + "%";
                this.message(message);
            }
            this.flushedDocCount += this.flushState.numDocs;
            this.doAfterFlush();
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
        if (!$assertionsDisabled && this.waitQueue.waitingBytes != 0L) {
            throw new AssertionError();
        }
        return this.flushState.numDocs;
    }

    void createCompoundFile(String segment) throws IOException {
        CompoundFileWriter cfsWriter = new CompoundFileWriter(this.directory, segment + "." + "cfs");
        Iterator it = this.flushState.flushedFiles.iterator();
        while (it.hasNext()) {
            cfsWriter.addFile((String)it.next());
        }
        cfsWriter.close();
    }

    synchronized boolean setFlushPending() {
        if (this.flushPending) {
            return false;
        }
        this.flushPending = true;
        return true;
    }

    synchronized void clearFlushPending() {
        this.flushPending = false;
    }

    synchronized void pushDeletes() {
        this.deletesFlushed.update(this.deletesInRAM);
    }

    synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    synchronized void initSegmentName(boolean onlyDocStore) {
        if (!(this.segment != null || onlyDocStore && this.docStoreSegment != null)) {
            this.segment = this.writer.newSegmentName();
            if (!$assertionsDisabled && this.numDocsInRAM != 0) {
                throw new AssertionError();
            }
        }
        if (this.docStoreSegment == null) {
            this.docStoreSegment = this.segment;
            if (!$assertionsDisabled && this.numDocsInStore != 0) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized DocumentsWriterThreadState getThreadState(Document doc, Term delTerm) throws IOException {
        DocumentsWriterThreadState state = (DocumentsWriterThreadState)this.threadBindings.get(Thread.currentThread());
        if (state == null) {
            DocumentsWriterThreadState minThreadState = null;
            for (int i = 0; i < this.threadStates.length; ++i) {
                DocumentsWriterThreadState ts = this.threadStates[i];
                if (minThreadState != null && ts.numThreads >= minThreadState.numThreads) continue;
                minThreadState = ts;
            }
            if (minThreadState != null && (minThreadState.numThreads == 0 || this.threadStates.length >= 5)) {
                state = minThreadState;
                ++state.numThreads;
            } else {
                DocumentsWriterThreadState[] newArray = new DocumentsWriterThreadState[1 + this.threadStates.length];
                if (this.threadStates.length > 0) {
                    System.arraycopy(this.threadStates, 0, newArray, 0, this.threadStates.length);
                }
                DocumentsWriterThreadState documentsWriterThreadState = new DocumentsWriterThreadState(this);
                newArray[this.threadStates.length] = documentsWriterThreadState;
                state = documentsWriterThreadState;
                this.threadStates = newArray;
            }
            this.threadBindings.put(Thread.currentThread(), state);
        }
        this.waitReady(state);
        this.initSegmentName(false);
        state.isIdle = false;
        boolean success = false;
        try {
            state.docState.docID = this.nextDocID;
            if (!$assertionsDisabled && !this.writer.testPoint("DocumentsWriter.ThreadState.init start")) {
                throw new AssertionError();
            }
            if (delTerm != null) {
                this.addDeleteTerm(delTerm, state.docState.docID);
                state.doFlushAfter = this.timeToFlushDeletes();
            }
            if (!$assertionsDisabled && !this.writer.testPoint("DocumentsWriter.ThreadState.init after delTerm")) {
                throw new AssertionError();
            }
            ++this.nextDocID;
            ++this.numDocsInRAM;
            if (!this.flushPending && this.maxBufferedDocs != -1 && this.numDocsInRAM >= this.maxBufferedDocs) {
                this.flushPending = true;
                state.doFlushAfter = true;
            }
            success = true;
        }
        finally {
            if (!success) {
                state.isIdle = true;
                this.notifyAll();
                if (state.doFlushAfter) {
                    state.doFlushAfter = false;
                    this.flushPending = false;
                }
            }
        }
        return state;
    }

    boolean addDocument(Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        return this.updateDocument(doc, analyzer, null);
    }

    boolean updateDocument(Term t, Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        return this.updateDocument(doc, analyzer, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateDocument(Document doc, Analyzer analyzer, Term delTerm) throws CorruptIndexException, IOException {
        DocumentsWriterThreadState state;
        block21: {
            DocumentsWriter documentsWriter;
            state = this.getThreadState(doc, delTerm);
            DocState docState = state.docState;
            docState.doc = doc;
            docState.analyzer = analyzer;
            boolean success = false;
            try {
                DocWriter perDoc;
                try {
                    perDoc = state.consumer.processDocument();
                    Object var9_8 = null;
                    docState.clear();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    docState.clear();
                    throw throwable;
                }
                this.finishDocument(state, perDoc);
                success = true;
                Object var11_11 = null;
                if (success) break block21;
                documentsWriter = this;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (!success) {
                    DocumentsWriter documentsWriter2 = this;
                    synchronized (documentsWriter2) {
                        if (this.aborting) {
                            state.isIdle = true;
                            this.notifyAll();
                            this.abort();
                        } else {
                            block23: {
                                this.skipDocWriter.docID = docState.docID;
                                boolean success2 = false;
                                try {
                                    this.waitQueue.add(this.skipDocWriter);
                                    success2 = true;
                                    Object var15_19 = null;
                                    if (success2) break block23;
                                    state.isIdle = true;
                                    this.notifyAll();
                                }
                                catch (Throwable throwable2) {
                                    Object var15_20 = null;
                                    if (!success2) {
                                        state.isIdle = true;
                                        this.notifyAll();
                                        this.abort();
                                        return false;
                                    }
                                    throw throwable2;
                                }
                                this.abort();
                                return false;
                            }
                            state.isIdle = true;
                            this.notifyAll();
                            if (state.doFlushAfter) {
                                state.doFlushAfter = false;
                                this.flushPending = false;
                                this.notifyAll();
                            }
                            this.addDeleteDocID(state.docState.docID);
                        }
                    }
                }
                throw throwable;
            }
            synchronized (documentsWriter) {
                if (this.aborting) {
                    state.isIdle = true;
                    this.notifyAll();
                    this.abort();
                } else {
                    block22: {
                        this.skipDocWriter.docID = docState.docID;
                        boolean success2 = false;
                        try {
                            this.waitQueue.add(this.skipDocWriter);
                            success2 = true;
                            Object var15_17 = null;
                            if (success2) break block22;
                            state.isIdle = true;
                            this.notifyAll();
                        }
                        catch (Throwable throwable) {
                            Object var15_18 = null;
                            if (!success2) {
                                state.isIdle = true;
                                this.notifyAll();
                                this.abort();
                                return false;
                            }
                            throw throwable;
                        }
                        this.abort();
                        return false;
                    }
                    state.isIdle = true;
                    this.notifyAll();
                    if (state.doFlushAfter) {
                        state.doFlushAfter = false;
                        this.flushPending = false;
                        this.notifyAll();
                    }
                    this.addDeleteDocID(state.docState.docID);
                }
            }
        }
        return state.doFlushAfter || this.timeToFlushDeletes();
    }

    synchronized int getNumBufferedDeleteTerms() {
        return this.deletesInRAM.numTerms;
    }

    synchronized Map getBufferedDeleteTerms() {
        return this.deletesInRAM.terms;
    }

    synchronized void remapDeletes(SegmentInfos infos, int[][] docMaps, int[] delCounts, MergePolicy.OneMerge merge, int mergeDocCount) {
        if (docMaps == null) {
            return;
        }
        MergeDocIDRemapper mapper = new MergeDocIDRemapper(infos, docMaps, delCounts, merge, mergeDocCount);
        this.deletesInRAM.remap(mapper, infos, docMaps, delCounts, merge, mergeDocCount);
        this.deletesFlushed.remap(mapper, infos, docMaps, delCounts, merge, mergeDocCount);
        this.flushedDocCount -= mapper.docShift;
    }

    private synchronized void waitReady(DocumentsWriterThreadState state) {
        while (!this.closed && (state != null && !state.isIdle || this.pauseThreads != 0 || this.flushPending || this.aborting)) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
        }
        if (this.closed) {
            throw new AlreadyClosedException("this IndexWriter is closed");
        }
    }

    synchronized boolean bufferDeleteTerms(Term[] terms) throws IOException {
        this.waitReady(null);
        for (int i = 0; i < terms.length; ++i) {
            this.addDeleteTerm(terms[i], this.numDocsInRAM);
        }
        return this.timeToFlushDeletes();
    }

    synchronized boolean bufferDeleteTerm(Term term) throws IOException {
        this.waitReady(null);
        this.addDeleteTerm(term, this.numDocsInRAM);
        return this.timeToFlushDeletes();
    }

    synchronized boolean bufferDeleteQueries(Query[] queries) throws IOException {
        this.waitReady(null);
        for (int i = 0; i < queries.length; ++i) {
            this.addDeleteQuery(queries[i], this.numDocsInRAM);
        }
        return this.timeToFlushDeletes();
    }

    synchronized boolean bufferDeleteQuery(Query query) throws IOException {
        this.waitReady(null);
        this.addDeleteQuery(query, this.numDocsInRAM);
        return this.timeToFlushDeletes();
    }

    synchronized boolean deletesFull() {
        return this.ramBufferSize != -1L && this.deletesInRAM.bytesUsed + this.deletesFlushed.bytesUsed + this.numBytesUsed >= this.ramBufferSize || this.maxBufferedDeleteTerms != -1 && this.deletesInRAM.size() + this.deletesFlushed.size() >= this.maxBufferedDeleteTerms;
    }

    synchronized boolean doApplyDeletes() {
        return this.ramBufferSize != -1L && this.deletesInRAM.bytesUsed + this.deletesFlushed.bytesUsed >= this.ramBufferSize / 2L || this.maxBufferedDeleteTerms != -1 && this.deletesInRAM.size() + this.deletesFlushed.size() >= this.maxBufferedDeleteTerms;
    }

    private synchronized boolean timeToFlushDeletes() {
        return (this.bufferIsFull || this.deletesFull()) && this.setFlushPending();
    }

    void setMaxBufferedDeleteTerms(int maxBufferedDeleteTerms) {
        this.maxBufferedDeleteTerms = maxBufferedDeleteTerms;
    }

    int getMaxBufferedDeleteTerms() {
        return this.maxBufferedDeleteTerms;
    }

    synchronized boolean hasDeletes() {
        return this.deletesFlushed.any();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean applyDeletes(SegmentInfos infos) throws IOException {
        if (!this.hasDeletes()) {
            return false;
        }
        if (this.infoStream != null) {
            this.message("apply " + this.deletesFlushed.numTerms + " buffered deleted terms and " + this.deletesFlushed.docIDs.size() + " deleted docIDs and " + this.deletesFlushed.queries.size() + " deleted queries on " + infos.size() + " segments.");
        }
        int infosEnd = infos.size();
        int docStart = 0;
        boolean any = false;
        for (int i = 0; i < infosEnd; ++i) {
            Object var8_7;
            if (!$assertionsDisabled && infos.info((int)i).dir != this.directory) {
                throw new AssertionError();
            }
            SegmentReader reader = this.writer.readerPool.get(infos.info(i), false);
            try {
                any |= this.applyDeletes(reader, docStart);
                docStart += reader.maxDoc();
                var8_7 = null;
            }
            catch (Throwable throwable) {
                var8_7 = null;
                this.writer.readerPool.release(reader);
                throw throwable;
            }
            this.writer.readerPool.release(reader);
        }
        this.deletesFlushed.clear();
        return any;
    }

    private boolean checkDeleteTerm(Term term) {
        if (term != null && !$assertionsDisabled && this.lastDeleteTerm != null && term.compareTo(this.lastDeleteTerm) <= 0) {
            throw new AssertionError((Object)("lastTerm=" + this.lastDeleteTerm + " vs term=" + term));
        }
        this.lastDeleteTerm = term;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized boolean applyDeletes(IndexReader reader, int docIDStart) throws CorruptIndexException, IOException {
        int docEnd = docIDStart + reader.maxDoc();
        boolean any = false;
        if (!$assertionsDisabled && !this.checkDeleteTerm(null)) {
            throw new AssertionError();
        }
        Iterator iter = this.deletesFlushed.terms.entrySet().iterator();
        TermDocs docs = reader.termDocs();
        try {
            while (iter.hasNext()) {
                int docID;
                Map.Entry entry = iter.next();
                Term term = (Term)entry.getKey();
                if (!$assertionsDisabled && !this.checkDeleteTerm(term)) {
                    throw new AssertionError();
                }
                docs.seek(term);
                int limit = ((BufferedDeletes.Num)entry.getValue()).getNum();
                while (docs.next() && docIDStart + (docID = docs.doc()) < limit) {
                    reader.deleteDocument(docID);
                    any = true;
                }
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            docs.close();
            throw throwable;
        }
        docs.close();
        iter = this.deletesFlushed.docIDs.iterator();
        while (iter.hasNext()) {
            int docID = (Integer)((Object)iter.next());
            if (docID < docIDStart || docID >= docEnd) continue;
            reader.deleteDocument(docID - docIDStart);
            any = true;
        }
        IndexSearcher searcher = new IndexSearcher(reader);
        iter = this.deletesFlushed.queries.entrySet().iterator();
        while (iter.hasNext()) {
            int doc;
            Map.Entry entry = iter.next();
            Query query = (Query)entry.getKey();
            int limit = (Integer)entry.getValue();
            Weight weight = query.weight(searcher);
            Scorer scorer = weight.scorer(reader, true, false);
            if (scorer == null) continue;
            while ((long)docIDStart + (long)(doc = scorer.nextDoc()) < (long)limit) {
                reader.deleteDocument(doc);
                any = true;
            }
        }
        searcher.close();
        return any;
    }

    private synchronized void addDeleteTerm(Term term, int docCount) {
        BufferedDeletes.Num num = (BufferedDeletes.Num)this.deletesInRAM.terms.get(term);
        int docIDUpto = this.flushedDocCount + docCount;
        if (num == null) {
            this.deletesInRAM.terms.put(term, new BufferedDeletes.Num(docIDUpto));
        } else {
            num.setNum(docIDUpto);
        }
        ++this.deletesInRAM.numTerms;
        this.deletesInRAM.addBytesUsed(BYTES_PER_DEL_TERM + term.text.length() * 2);
    }

    private synchronized void addDeleteDocID(int docID) {
        this.deletesInRAM.docIDs.add(new Integer(this.flushedDocCount + docID));
        this.deletesInRAM.addBytesUsed(BYTES_PER_DEL_DOCID);
    }

    private synchronized void addDeleteQuery(Query query, int docID) {
        this.deletesInRAM.queries.put(query, new Integer(this.flushedDocCount + docID));
        this.deletesInRAM.addBytesUsed(BYTES_PER_DEL_QUERY);
    }

    synchronized boolean doBalanceRAM() {
        return this.ramBufferSize != -1L && !this.bufferIsFull && (this.numBytesUsed + this.deletesInRAM.bytesUsed + this.deletesFlushed.bytesUsed >= this.ramBufferSize || this.numBytesAlloc >= this.freeTrigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishDocument(DocumentsWriterThreadState perThread, DocWriter docWriter) throws IOException {
        if (this.doBalanceRAM()) {
            this.balanceRAM();
        }
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            boolean doPause;
            if (!$assertionsDisabled && docWriter != null && docWriter.docID != perThread.docState.docID) {
                throw new AssertionError();
            }
            if (this.aborting) {
                if (docWriter != null) {
                    try {
                        docWriter.abort();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                perThread.isIdle = true;
                this.notifyAll();
                return;
            }
            if (docWriter != null) {
                doPause = this.waitQueue.add(docWriter);
            } else {
                this.skipDocWriter.docID = perThread.docState.docID;
                doPause = this.waitQueue.add(this.skipDocWriter);
            }
            if (doPause) {
                this.waitForWaitQueue();
            }
            if (this.bufferIsFull && !this.flushPending) {
                this.flushPending = true;
                perThread.doFlushAfter = true;
            }
            perThread.isIdle = true;
            this.notifyAll();
        }
    }

    synchronized void waitForWaitQueue() {
        do {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
        } while (!this.waitQueue.doResume());
    }

    long getRAMUsed() {
        return this.numBytesUsed + this.deletesInRAM.bytesUsed + this.deletesFlushed.bytesUsed;
    }

    synchronized int[] getIntBlock(boolean trackAllocations) {
        int[] b;
        int size = this.freeIntBlocks.size();
        if (0 == size) {
            this.numBytesAlloc += 32768L;
            b = new int[8192];
        } else {
            b = (int[])this.freeIntBlocks.remove(size - 1);
        }
        if (trackAllocations) {
            this.numBytesUsed += 32768L;
        }
        if (!$assertionsDisabled && this.numBytesUsed > this.numBytesAlloc) {
            throw new AssertionError();
        }
        return b;
    }

    synchronized void bytesAllocated(long numBytes) {
        this.numBytesAlloc += numBytes;
    }

    synchronized void bytesUsed(long numBytes) {
        this.numBytesUsed += numBytes;
        if (!$assertionsDisabled && this.numBytesUsed > this.numBytesAlloc) {
            throw new AssertionError();
        }
    }

    synchronized void recycleIntBlocks(int[][] blocks, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.freeIntBlocks.add(blocks[i]);
            blocks[i] = null;
        }
        if (this.infoStream != null) {
            this.message("DW.recycleIntBlocks count=" + (end - start) + " total now " + this.freeIntBlocks.size());
        }
    }

    synchronized char[] getCharBlock() {
        char[] c;
        int size = this.freeCharBlocks.size();
        if (0 == size) {
            this.numBytesAlloc += 32768L;
            c = new char[16384];
        } else {
            c = (char[])this.freeCharBlocks.remove(size - 1);
        }
        this.numBytesUsed += 32768L;
        if (!$assertionsDisabled && this.numBytesUsed > this.numBytesAlloc) {
            throw new AssertionError();
        }
        return c;
    }

    synchronized void recycleCharBlocks(char[][] blocks, int numBlocks) {
        for (int i = 0; i < numBlocks; ++i) {
            this.freeCharBlocks.add(blocks[i]);
            blocks[i] = null;
        }
        if (this.infoStream != null) {
            this.message("DW.recycleCharBlocks count=" + numBlocks + " total now " + this.freeCharBlocks.size());
        }
    }

    String toMB(long v) {
        return this.nf.format((double)v / 1024.0 / 1024.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void balanceRAM() {
        long flushTrigger = this.ramBufferSize;
        long deletesRAMUsed = this.deletesInRAM.bytesUsed + this.deletesFlushed.bytesUsed;
        if (this.numBytesAlloc + deletesRAMUsed > this.freeTrigger) {
            if (this.infoStream != null) {
                this.message("  RAM: now balance allocations: usedMB=" + this.toMB(this.numBytesUsed) + " vs trigger=" + this.toMB(flushTrigger) + " allocMB=" + this.toMB(this.numBytesAlloc) + " deletesMB=" + this.toMB(deletesRAMUsed) + " vs trigger=" + this.toMB(this.freeTrigger) + " byteBlockFree=" + this.toMB(this.byteBlockAllocator.freeByteBlocks.size() * 32768) + " perDocFree=" + this.toMB(this.perDocAllocator.freeByteBlocks.size() * 1024) + " charBlockFree=" + this.toMB(this.freeCharBlocks.size() * 16384 * 2));
            }
            long startBytesAlloc = this.numBytesAlloc + deletesRAMUsed;
            int iter = 0;
            boolean any = true;
            while (this.numBytesAlloc + deletesRAMUsed > this.freeLevel) {
                DocumentsWriter documentsWriter = this;
                synchronized (documentsWriter) {
                    if (0 == this.perDocAllocator.freeByteBlocks.size() && 0 == this.byteBlockAllocator.freeByteBlocks.size() && 0 == this.freeCharBlocks.size() && 0 == this.freeIntBlocks.size() && !any) {
                        boolean bl = this.bufferIsFull = this.numBytesUsed + deletesRAMUsed > flushTrigger;
                        if (this.infoStream != null) {
                            if (this.bufferIsFull) {
                                this.message("    nothing to free; now set bufferIsFull");
                            } else {
                                this.message("    nothing to free");
                            }
                        }
                        if (!$assertionsDisabled && this.numBytesUsed > this.numBytesAlloc) {
                            throw new AssertionError();
                        }
                        break;
                    }
                    if (0 == iter % 5 && this.byteBlockAllocator.freeByteBlocks.size() > 0) {
                        this.byteBlockAllocator.freeByteBlocks.remove(this.byteBlockAllocator.freeByteBlocks.size() - 1);
                        this.numBytesAlloc -= 32768L;
                    }
                    if (1 == iter % 5 && this.freeCharBlocks.size() > 0) {
                        this.freeCharBlocks.remove(this.freeCharBlocks.size() - 1);
                        this.numBytesAlloc -= 32768L;
                    }
                    if (2 == iter % 5 && this.freeIntBlocks.size() > 0) {
                        this.freeIntBlocks.remove(this.freeIntBlocks.size() - 1);
                        this.numBytesAlloc -= 32768L;
                    }
                    if (3 == iter % 5 && this.perDocAllocator.freeByteBlocks.size() > 0) {
                        for (int i = 0; i < 32; ++i) {
                            this.perDocAllocator.freeByteBlocks.remove(this.perDocAllocator.freeByteBlocks.size() - 1);
                            this.numBytesAlloc -= 1024L;
                            if (this.perDocAllocator.freeByteBlocks.size() == 0) break;
                        }
                    }
                }
                if (4 == iter % 5 && any) {
                    any = this.consumer.freeRAM();
                }
                ++iter;
            }
            if (this.infoStream != null) {
                this.message("    after free: freedMB=" + this.nf.format((double)(startBytesAlloc - this.numBytesAlloc - deletesRAMUsed) / 1024.0 / 1024.0) + " usedMB=" + this.nf.format((double)(this.numBytesUsed + deletesRAMUsed) / 1024.0 / 1024.0) + " allocMB=" + this.nf.format((double)this.numBytesAlloc / 1024.0 / 1024.0));
            }
        } else {
            DocumentsWriter documentsWriter = this;
            synchronized (documentsWriter) {
                if (this.numBytesUsed + deletesRAMUsed > flushTrigger) {
                    if (this.infoStream != null) {
                        this.message("  RAM: now flush @ usedMB=" + this.nf.format((double)this.numBytesUsed / 1024.0 / 1024.0) + " allocMB=" + this.nf.format((double)this.numBytesAlloc / 1024.0 / 1024.0) + " deletesMB=" + this.nf.format((double)deletesRAMUsed / 1024.0 / 1024.0) + " triggerMB=" + this.nf.format((double)flushTrigger / 1024.0 / 1024.0));
                    }
                    this.bufferIsFull = true;
                }
            }
        }
    }

    static {
        $assertionsDisabled = !DocumentsWriter.class.desiredAssertionStatus();
        DefaultIndexingChain = new IndexingChain(){

            DocConsumer getChain(DocumentsWriter documentsWriter) {
                TermVectorsTermsWriter termVectorsWriter = new TermVectorsTermsWriter(documentsWriter);
                FreqProxTermsWriter freqProxWriter = new FreqProxTermsWriter();
                TermsHash termsHash = new TermsHash(documentsWriter, true, freqProxWriter, new TermsHash(documentsWriter, false, termVectorsWriter, null));
                NormsWriter normsWriter = new NormsWriter();
                DocInverter docInverter = new DocInverter(termsHash, normsWriter);
                return new DocFieldProcessor(documentsWriter, docInverter);
            }
        };
        POINTER_NUM_BYTE = Constants.JRE_IS_64BIT ? 8 : 4;
        BYTES_PER_DEL_TERM = 8 * POINTER_NUM_BYTE + 40 + 24;
        BYTES_PER_DEL_DOCID = 2 * POINTER_NUM_BYTE + 8 + 4;
        BYTES_PER_DEL_QUERY = 5 * POINTER_NUM_BYTE + 16 + 8 + 24;
    }

    private class WaitQueue {
        DocWriter[] waiting = new DocWriter[10];
        int nextWriteDocID;
        int nextWriteLoc;
        int numWaiting;
        long waitingBytes;
        static final /* synthetic */ boolean $assertionsDisabled;

        synchronized void reset() {
            if (!$assertionsDisabled && this.numWaiting != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.waitingBytes != 0L) {
                throw new AssertionError();
            }
            this.nextWriteDocID = 0;
        }

        synchronized boolean doResume() {
            return this.waitingBytes <= DocumentsWriter.this.waitQueueResumeBytes;
        }

        synchronized boolean doPause() {
            return this.waitingBytes > DocumentsWriter.this.waitQueuePauseBytes;
        }

        synchronized void abort() {
            int count = 0;
            for (int i = 0; i < this.waiting.length; ++i) {
                DocWriter doc = this.waiting[i];
                if (doc == null) continue;
                doc.abort();
                this.waiting[i] = null;
                ++count;
            }
            this.waitingBytes = 0L;
            if (!$assertionsDisabled && count != this.numWaiting) {
                throw new AssertionError();
            }
            this.numWaiting = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeDocument(DocWriter doc) throws IOException {
            if (!$assertionsDisabled && doc != DocumentsWriter.this.skipDocWriter && this.nextWriteDocID != doc.docID) {
                throw new AssertionError();
            }
            boolean success = false;
            try {
                doc.finish();
                ++this.nextWriteDocID;
                ++DocumentsWriter.this.numDocsInStore;
                ++this.nextWriteLoc;
                if (!$assertionsDisabled && this.nextWriteLoc > this.waiting.length) {
                    throw new AssertionError();
                }
                if (this.nextWriteLoc == this.waiting.length) {
                    this.nextWriteLoc = 0;
                }
                success = true;
            }
            finally {
                if (!success) {
                    DocumentsWriter.this.setAborting();
                }
            }
        }

        public synchronized boolean add(DocWriter doc) throws IOException {
            if (!$assertionsDisabled && doc.docID < this.nextWriteDocID) {
                throw new AssertionError();
            }
            if (doc.docID == this.nextWriteDocID) {
                this.writeDocument(doc);
                while ((doc = this.waiting[this.nextWriteLoc]) != null) {
                    --this.numWaiting;
                    this.waiting[this.nextWriteLoc] = null;
                    this.waitingBytes -= doc.sizeInBytes();
                    this.writeDocument(doc);
                }
            } else {
                int loc;
                int gap = doc.docID - this.nextWriteDocID;
                if (gap >= this.waiting.length) {
                    DocWriter[] newArray = new DocWriter[ArrayUtil.getNextSize(gap)];
                    if (!$assertionsDisabled && this.nextWriteLoc < 0) {
                        throw new AssertionError();
                    }
                    System.arraycopy(this.waiting, this.nextWriteLoc, newArray, 0, this.waiting.length - this.nextWriteLoc);
                    System.arraycopy(this.waiting, 0, newArray, this.waiting.length - this.nextWriteLoc, this.nextWriteLoc);
                    this.nextWriteLoc = 0;
                    this.waiting = newArray;
                    gap = doc.docID - this.nextWriteDocID;
                }
                if ((loc = this.nextWriteLoc + gap) >= this.waiting.length) {
                    loc -= this.waiting.length;
                }
                if (!$assertionsDisabled && loc >= this.waiting.length) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.waiting[loc] != null) {
                    throw new AssertionError();
                }
                this.waiting[loc] = doc;
                ++this.numWaiting;
                this.waitingBytes += doc.sizeInBytes();
            }
            return this.doPause();
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$DocumentsWriter == null ? (class$org$apache$lucene$index$DocumentsWriter = DocumentsWriter.class$("org.apache.lucene.index.DocumentsWriter")) : class$org$apache$lucene$index$DocumentsWriter).desiredAssertionStatus();
        }
    }

    private class ByteBlockAllocator
    extends ByteBlockPool.Allocator {
        final int blockSize;
        ArrayList freeByteBlocks = new ArrayList();
        static final /* synthetic */ boolean $assertionsDisabled;

        ByteBlockAllocator(int blockSize) {
            this.blockSize = blockSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] getByteBlock(boolean trackAllocations) {
            DocumentsWriter documentsWriter = DocumentsWriter.this;
            synchronized (documentsWriter) {
                byte[] b;
                int size = this.freeByteBlocks.size();
                if (0 == size) {
                    DocumentsWriter.this.numBytesAlloc += (long)this.blockSize;
                    b = new byte[this.blockSize];
                } else {
                    b = (byte[])this.freeByteBlocks.remove(size - 1);
                }
                if (trackAllocations) {
                    DocumentsWriter.this.numBytesUsed += (long)this.blockSize;
                }
                if (!$assertionsDisabled && DocumentsWriter.this.numBytesUsed > DocumentsWriter.this.numBytesAlloc) {
                    throw new AssertionError();
                }
                return b;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recycleByteBlocks(byte[][] blocks, int start, int end) {
            DocumentsWriter documentsWriter = DocumentsWriter.this;
            synchronized (documentsWriter) {
                for (int i = start; i < end; ++i) {
                    this.freeByteBlocks.add(blocks[i]);
                    blocks[i] = null;
                }
                if (DocumentsWriter.this.infoStream != null && this.blockSize != 1024) {
                    DocumentsWriter.this.message("DW.recycleByteBlocks blockSize=" + this.blockSize + " count=" + (end - start) + " total now " + this.freeByteBlocks.size());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recycleByteBlocks(List blocks) {
            DocumentsWriter documentsWriter = DocumentsWriter.this;
            synchronized (documentsWriter) {
                int size = blocks.size();
                for (int i = 0; i < size; ++i) {
                    this.freeByteBlocks.add(blocks.get(i));
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$DocumentsWriter == null ? (class$org$apache$lucene$index$DocumentsWriter = DocumentsWriter.class$("org.apache.lucene.index.DocumentsWriter")) : class$org$apache$lucene$index$DocumentsWriter).desiredAssertionStatus();
        }
    }

    private static class SkipDocWriter
    extends DocWriter {
        private SkipDocWriter() {
        }

        void finish() {
        }

        void abort() {
        }

        long sizeInBytes() {
            return 0L;
        }
    }

    static abstract class IndexingChain {
        IndexingChain() {
        }

        abstract DocConsumer getChain(DocumentsWriter var1);
    }

    class PerDocBuffer
    extends RAMFile {
        static final /* synthetic */ boolean $assertionsDisabled;

        PerDocBuffer() {
        }

        protected byte[] newBuffer(int size) {
            if (!$assertionsDisabled && size != 1024) {
                throw new AssertionError();
            }
            return DocumentsWriter.this.perDocAllocator.getByteBlock(false);
        }

        synchronized void recycle() {
            if (this.buffers.size() > 0) {
                this.setLength(0L);
                DocumentsWriter.this.perDocAllocator.recycleByteBlocks(this.buffers);
                this.buffers.clear();
                this.sizeInBytes = 0L;
                if (!$assertionsDisabled && this.numBuffers() != 0) {
                    throw new AssertionError();
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$DocumentsWriter == null ? (class$org$apache$lucene$index$DocumentsWriter = DocumentsWriter.class$("org.apache.lucene.index.DocumentsWriter")) : class$org$apache$lucene$index$DocumentsWriter).desiredAssertionStatus();
        }
    }

    static abstract class DocWriter {
        DocWriter next;
        int docID;

        DocWriter() {
        }

        abstract void finish() throws IOException;

        abstract void abort();

        abstract long sizeInBytes();

        void setNext(DocWriter next) {
            this.next = next;
        }
    }

    static class DocState {
        DocumentsWriter docWriter;
        Analyzer analyzer;
        int maxFieldLength;
        PrintStream infoStream;
        Similarity similarity;
        int docID;
        Document doc;
        String maxTermPrefix;
        boolean allowMinus1Position;

        DocState() {
        }

        public boolean testPoint(String name) {
            return this.docWriter.writer.testPoint(name);
        }

        public void clear() {
            this.doc = null;
            this.analyzer = null;
        }
    }
}

